/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.server.network;

import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.inventory.container.MenuBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.inventory.custom.SpongeInventoryMenu;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class ServerGamePacketListenerImplMixin_Inventory {
    @Shadow
    public ServerPlayer player;

    @Redirect(method={"handleSetCreativeModeSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/InventoryMenu;broadcastChanges()V"))
    private void impl$onBroadcastCreativeActionResult(InventoryMenu inventoryMenu, ServerboundSetCreativeModeSlotPacket packetIn) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        ItemStack itemstack = packetIn.getItem();
        EffectTransactor ignored = transactor.logCreativeClickContainer(packetIn.getSlotNum(), ItemStackUtil.snapshotOf(itemstack), (Player)this.player);
        if (ignored != null) {
            ignored.close();
        }
        inventoryMenu.broadcastChanges();
    }

    @Redirect(method={"handleSetCreativeModeSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;drop(Lnet/minecraft/world/item/ItemStack;Z)Lnet/minecraft/world/entity/item/ItemEntity;"))
    private ItemEntity impl$onBroadcastCreativeActionResult(ServerPlayer serverPlayer, ItemStack stack, boolean param1) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try (EffectTransactor ignored = transactor.logCreativeClickContainer(-1, ItemStackUtil.snapshotOf(stack), (Player)this.player);){
            ItemEntity itemEntity = serverPlayer.drop(stack, param1);
            return itemEntity;
        }
    }

    @Inject(method={"handleSetCarriedItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/game/ServerboundSetCarriedItemPacket;getSlot()I")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;stopUsingItem()V"))})
    private void impl$onHandleSetCarriedItem(ServerboundSetCarriedItemPacket packet, CallbackInfo ci) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        int slotIdx = packet.getSlot();
        transactor.logPlayerCarriedItem((Player)this.player, slotIdx);
    }

    @Redirect(method={"handleContainerClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AbstractContainerMenu;sendAllDataToRemote()V"))
    private void impl$onSpectatorClick(AbstractContainerMenu menu, ServerboundContainerClickPacket packet) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try (EffectTransactor ignored = transactor.logClickContainer(menu, packet.getSlotNum(), packet.getButtonNum(), packet.getClickType(), (Player)this.player);){
            MenuBridge bridge;
            SpongeInventoryMenu spongeMenu;
            if (menu instanceof MenuBridge && (spongeMenu = (bridge = (MenuBridge)menu).bridge$getMenu()) != null) {
                spongeMenu.onClick(packet.getSlotNum(), packet.getButtonNum(), packet.getClickType(), (Player)this.player, (Container)menu);
            }
            menu.sendAllDataToRemote();
        }
    }

    @Redirect(method={"handleUseItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;useItem(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"))
    private InteractionResult impl$onHandleUseItem(ServerPlayerGameMode serverPlayerGameMode, ServerPlayer param0, Level param1, ItemStack param2, InteractionHand param3) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try (EffectTransactor ignored = transactor.logPlayerInventoryChangeWithEffect((Player)this.player, PlayerInventoryTransaction.EventCreator.STANDARD);){
            InteractionResult result = serverPlayerGameMode.useItem(param0, param1, param2, param3);
            this.player.inventoryMenu.broadcastChanges();
            InteractionResult interactionResult = result;
            return interactionResult;
        }
    }

    @Redirect(method={"handleContainerClose"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;doCloseContainer()V"))
    private void impl$onHandleContainerClose(ServerPlayer player) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try (EffectTransactor ignored = transactor.logCloseInventory((Player)player, true);){
            this.player.containerMenu.removed((Player)player);
            this.player.containerMenu.broadcastChanges();
        }
    }

    @Redirect(method={"handleRenameItem(Lnet/minecraft/network/protocol/game/ServerboundRenameItemPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AnvilMenu;setItemName(Ljava/lang/String;)Z"))
    private boolean impl$onHandleRenameItem(AnvilMenu menu, String name) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try (EffectTransactor ignored = transactor.logIgnoredInventory(this.player.containerMenu);){
            boolean bl = menu.setItemName(name);
            return bl;
        }
    }

    @Inject(method={"handleSelectTrade"}, at={@At(value="RETURN")})
    private void impl$onHandleSelectTrade(ServerboundSelectTradePacket param0, CallbackInfo ci) {
        if (this.player.containerMenu instanceof MerchantMenu) {
            PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
            TransactionalCaptureSupplier transactor = context.getTransactor();
            transactor.logSelectTrade(this.player, param0.getItem());
            this.player.containerMenu.broadcastChanges();
        }
    }
}

