/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.custom.CustomQueryAnswerPayload;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.ChannelBuf;

public final class PacketUtil {
    private static final Object UNSAFE;
    private static final MethodHandle ALLOCATE_INSTANCE;

    public static Packet<?> createLoginPayloadResponse(@Nullable CustomQueryAnswerPayload payload, int transactionId) {
        return new ServerboundCustomQueryAnswerPacket(transactionId, payload);
    }

    public static Packet<?> createLoginPayloadRequest(CustomQueryPayload payload, int transactionId) {
        return new ClientboundCustomQueryPacket(transactionId, payload);
    }

    public static Packet<?> createPlayPayload(final ResourceKey channel, final ChannelBuf payload, EngineConnectionSide<?> side) {
        if (side == EngineConnectionSide.CLIENT) {
            return new ServerboundCustomPayloadPacket(new CustomPacketPayload(){

                public void write(FriendlyByteBuf var1) {
                    var1.writeBytes((ByteBuf)((FriendlyByteBuf)payload));
                }

                public ResourceLocation id() {
                    return (ResourceLocation)channel;
                }
            });
        }
        if (side == EngineConnectionSide.SERVER) {
            return new ClientboundCustomPayloadPacket(new CustomPacketPayload(){

                public void write(FriendlyByteBuf var1) {
                    var1.writeBytes((ByteBuf)((FriendlyByteBuf)payload));
                }

                public ResourceLocation id() {
                    return (ResourceLocation)channel;
                }
            });
        }
        throw new UnsupportedOperationException();
    }

    public static <P extends org.spongepowered.api.network.channel.packet.Packet> Supplier<P> getConstructor(Class<P> packetClass) {
        Constructor constructor;
        try {
            constructor = packetClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return () -> {
            try {
                return (org.spongepowered.api.network.channel.packet.Packet)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
    }

    private static <P extends Packet<?>> @NonNull P createPacketWithoutConstructor(@NonNull Class<P> packet) {
        try {
            return (P)ALLOCATE_INSTANCE.invoke(UNSAFE, packet);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to create instance of packet " + packet, ex);
        }
    }

    private PacketUtil() {
    }

    static {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            UNSAFE = unsafeField.get(null);
            ALLOCATE_INSTANCE = MethodHandles.lookup().findVirtual(unsafeClass, "allocateInstance", MethodType.methodType(Object.class, Class.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            throw new ExceptionInInitializerError("Unable to access Unsafe instance!");
        }
    }
}

