/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.LocalPlayerConnection;
import org.spongepowered.api.network.PlayerConnection;
import org.spongepowered.api.network.ServerPlayerConnection;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.api.network.channel.Channel;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelExceptionHandler;
import org.spongepowered.api.network.channel.ChannelNotSupportedException;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.network.channel.ChannelExceptionUtil;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.TransactionResult;

public abstract class SpongeChannel
implements Channel {
    private final ResourceKey key;
    private final SpongeChannelManager manager;
    private final Logger logger;
    private final int type;
    private volatile ChannelExceptionHandler<EngineConnection> exceptionHandler = ChannelExceptionHandler.logEverything().suppress(ChannelNotSupportedException.class);

    public SpongeChannel(int type, ResourceKey key, SpongeChannelManager manager) {
        this.type = type;
        this.key = key;
        this.manager = manager;
        this.logger = LogManager.getLogger((String)("channel/" + key.formatted()));
    }

    public int getType() {
        return this.type;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public SpongeChannelManager manager() {
        return this.manager;
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    @Override
    public void setExceptionHandler(ChannelExceptionHandler<EngineConnection> handler) {
        Objects.requireNonNull(handler, "handler");
        this.exceptionHandler = handler;
    }

    public String toString() {
        return new StringJoiner(", ", SpongeChannel.class.getSimpleName() + "[", "]").add("key=" + this.key).toString();
    }

    public boolean checkSupported(EngineConnection connection, CompletableFuture<?> future) {
        if (!ConnectionUtil.getRegisteredChannels(connection).contains(this.key())) {
            this.handleException(connection, new ChannelNotSupportedException("The channel \"" + this.key() + "\" isn't supported."), future);
            return false;
        }
        return true;
    }

    protected abstract void handlePlayPayload(EngineConnection var1, ChannelBuf var2);

    protected abstract void handleLoginRequestPayload(EngineConnection var1, int var2, ChannelBuf var3);

    protected abstract void handleTransactionResponse(EngineConnection var1, Object var2, TransactionResult var3);

    public void handleException(EngineConnection connection, Throwable cause, @Nullable CompletableFuture<?> future) {
        try {
            this.exceptionHandler.handle(connection, this, ChannelExceptionUtil.of(cause), future);
        }
        catch (Throwable ex) {
            SpongeCommon.logger().error("The exception handler of the channel " + this.key() + " failed to handle an exception.", ex);
        }
    }

    public static <C extends EngineConnection> Class<C> getConnectionClass(EngineConnectionSide<C> side) {
        return side == EngineConnectionSide.CLIENT ? ClientSideConnection.class : ServerSideConnection.class;
    }

    public static <H> @Nullable H getRequestHandler(EngineConnection connection, Map<Class<?>, H> handlersMap) {
        H handler = null;
        if (connection instanceof LocalPlayerConnection) {
            handler = handlersMap.get(LocalPlayerConnection.class);
        } else if (connection instanceof ServerPlayerConnection) {
            handler = handlersMap.get(ServerPlayerConnection.class);
        }
        if (handler == null && connection instanceof PlayerConnection) {
            handler = handlersMap.get(PlayerConnection.class);
        }
        if (handler == null) {
            if (connection instanceof ClientSideConnection) {
                handler = handlersMap.get(ClientSideConnection.class);
            } else if (connection instanceof ServerSideConnection) {
                handler = handlersMap.get(ServerSideConnection.class);
            }
        }
        if (handler == null) {
            handler = handlersMap.get(EngineConnection.class);
        }
        return handler;
    }

    public static <H> Collection<H> getResponseHandlers(EngineConnection connection, Multimap<Class<?>, H> handlersMap) {
        ArrayList handlers = null;
        boolean modifiable = false;
        for (Map.Entry entry : handlersMap.asMap().entrySet()) {
            if (!((Class)entry.getKey()).isInstance(connection)) continue;
            if (handlers == null) {
                handlers = (ArrayList)entry.getValue();
                continue;
            }
            if (!modifiable) {
                handlers = new ArrayList(handlers);
                modifiable = true;
                continue;
            }
            handlers.addAll((Collection)entry.getValue());
        }
        return handlers == null ? Collections.emptyList() : handlers;
    }
}

