/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.status;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.StringJoiner;
import javax.imageio.ImageIO;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.common.util.Preconditions;

public class SpongeFavicon
implements Favicon {
    private final String encoded;
    private final BufferedImage decoded;
    private static final String FAVICON_PREFIX = "data:image/png;base64,";

    public SpongeFavicon(BufferedImage decoded) throws IOException {
        this.decoded = Objects.requireNonNull(decoded, "decoded");
        this.encoded = SpongeFavicon.encode(decoded);
    }

    public SpongeFavicon(String encoded) throws IOException {
        this.encoded = Objects.requireNonNull(encoded, "encoded");
        this.decoded = SpongeFavicon.decode(encoded);
    }

    public String getEncoded() {
        return this.encoded;
    }

    @Override
    public BufferedImage image() {
        return this.decoded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpongeFavicon)) {
            return false;
        }
        SpongeFavicon that = (SpongeFavicon)o;
        return Objects.equals(this.encoded, that.encoded);
    }

    public int hashCode() {
        return this.encoded.hashCode();
    }

    public String toString() {
        return new StringJoiner(", ", SpongeFavicon.class.getSimpleName() + "[", "]").add("image=" + this.decoded).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encode(BufferedImage favicon) throws IOException {
        Preconditions.checkArgument(favicon.getWidth() == 64, "favicon must be 64 pixels wide");
        Preconditions.checkArgument(favicon.getHeight() == 64, "favicon must be 64 pixels high");
        ByteBuf buf = Unpooled.buffer();
        try {
            String string;
            ImageIO.write((RenderedImage)favicon, "PNG", (OutputStream)new ByteBufOutputStream(buf));
            ByteBuf base64 = Base64.encode((ByteBuf)buf);
            try {
                string = FAVICON_PREFIX + base64.toString(StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                base64.release();
                throw throwable;
            }
            base64.release();
            return string;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage decode(String encoded) throws IOException {
        Preconditions.checkArgument(encoded.startsWith(FAVICON_PREFIX), "Unknown favicon format");
        ByteBuf base64 = Unpooled.copiedBuffer((CharSequence)encoded.substring(FAVICON_PREFIX.length()), (Charset)StandardCharsets.UTF_8);
        try {
            BufferedImage bufferedImage;
            ByteBuf buf = Base64.decode((ByteBuf)base64);
            try {
                BufferedImage result = ImageIO.read((InputStream)new ByteBufInputStream(buf));
                Preconditions.checkState(result.getWidth() == 64, "favicon must be 64 pixels wide");
                Preconditions.checkState(result.getHeight() == 64, "favicon must be 64 pixels high");
                bufferedImage = result;
            }
            catch (Throwable throwable) {
                buf.release();
                throw throwable;
            }
            buf.release();
            return bufferedImage;
        }
        finally {
            base64.release();
        }
    }

    public static final class FactoryImpl
    implements Favicon.Factory {
        @Override
        public Favicon load(String raw) throws IOException {
            return new SpongeFavicon(raw);
        }

        @Override
        public Favicon load(Path path) throws IOException {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                Favicon favicon = this.load(in);
                return favicon;
            }
        }

        @Override
        public Favicon load(URL url) throws IOException {
            return this.load(ImageIO.read(url));
        }

        @Override
        public Favicon load(InputStream in) throws IOException {
            return this.load(ImageIO.read(in));
        }

        @Override
        public Favicon load(BufferedImage image) throws IOException {
            return new SpongeFavicon(image);
        }
    }
}

