/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Objects;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.common.util.Preconditions;

public final class SpongeResourceKeyBuilder
implements ResourceKey.Builder {
    private String namespace;
    private String value;

    @Override
    public ResourceKey.Builder namespace(String namespace) {
        Objects.requireNonNull(namespace, "Namespace cannot be null");
        this.namespace = namespace;
        return this;
    }

    @Override
    public ResourceKey.Builder value(String value) {
        Objects.requireNonNull(value, "Value cannot be null");
        this.value = value;
        return this;
    }

    @Override
    public ResourceKey build() throws IllegalStateException {
        Preconditions.checkState(this.namespace != null, "Namespace cannot be empty");
        Preconditions.checkState(this.value != null, "Value cannot be empty");
        try {
            ResourceLocation resourceLocation = new ResourceLocation(this.namespace, this.value);
            return (ResourceKey)resourceLocation;
        }
        catch (ResourceLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ResourceKey.Builder reset() {
        this.namespace = null;
        this.value = null;
        return this;
    }
}

