/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.ScoreFormat;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.scoreboard.SpongeObjective;

public final class SpongeScore
implements Score {
    private final String name;
    public ScoreHolder holder;
    private int score;
    private boolean locked;
    @Nullable
    private Component display;
    @Nullable
    private NumberFormat numberFormat;
    private Set<Objective> objectives = new HashSet<Objective>();

    public SpongeScore(String name) {
        this.name = name;
        this.holder = ScoreHolder.forNameOnly((String)name);
    }

    public SpongeScore(GameProfile profile) {
        this.holder = ScoreHolder.fromGameProfile((com.mojang.authlib.GameProfile)SpongeGameProfile.toMcProfile(profile));
        this.name = this.holder.getScoreboardName();
    }

    public SpongeScore(Entity entity) {
        this.holder = (net.minecraft.world.entity.Entity)entity;
        this.name = this.holder.getScoreboardName();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int score() {
        return this.score;
    }

    @Override
    public void setScore(int score) {
        this.score = score;
        this.updateScore();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
        this.updateScore();
    }

    @Override
    public void setDisplay(net.kyori.adventure.text.Component display) {
        this.display = SpongeAdventure.asVanilla(display);
        this.updateScore();
    }

    @Override
    public Optional<net.kyori.adventure.text.Component> display() {
        return Optional.ofNullable(this.display == null ? null : SpongeAdventure.asAdventure(this.display));
    }

    @Override
    public void setNumberFormat(@org.checkerframework.checker.nullness.qual.Nullable ScoreFormat format) {
        this.numberFormat = (NumberFormat)format;
        this.updateScore();
    }

    @Override
    public Optional<ScoreFormat> numberFormat() {
        return Optional.ofNullable((ScoreFormat)this.numberFormat);
    }

    private void updateScore() {
        for (Objective objective : this.objectives) {
            Scoreboard scoreboard = objective.getScoreboard();
            ScoreAccess access = scoreboard.getOrCreatePlayerScore(this.holder, objective);
            this.registerAndUpdate(objective, access);
        }
    }

    @Override
    public Set<org.spongepowered.api.scoreboard.objective.Objective> objectives() {
        HashSet<org.spongepowered.api.scoreboard.objective.Objective> objectives = new HashSet<org.spongepowered.api.scoreboard.objective.Objective>();
        for (Objective objective : this.objectives) {
            objectives.add(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return objectives;
    }

    public void registerAndUpdate(Objective objective, ScoreAccess accessor) {
        this.objectives.add(objective);
        accessor.set(this.score);
        accessor.display(this.display);
        accessor.numberFormatOverride(this.numberFormat);
        if (this.locked) {
            accessor.lock();
        } else {
            accessor.unlock();
        }
    }

    public void unregister(Objective objective) {
        this.objectives.remove(objective);
    }

    public record SpongeScoreAccess(ScoreHolder holder, Objective objective, ScoreAccess access) implements ScoreAccess
    {
        public int get() {
            return this.access.get();
        }

        public boolean locked() {
            return this.access.locked();
        }

        @Nullable
        public Component display() {
            return this.access.display();
        }

        public void set(int var1) {
            SpongeObjective spongeObjective = ((ObjectiveBridge)this.objective).bridge$getSpongeObjective();
            spongeObjective.findScore(this.holder.getScoreboardName()).ifPresent(spongeScore -> {
                if (spongeScore.score() != var1) {
                    spongeScore.setScore(var1);
                }
            });
            this.access.set(var1);
        }

        public void unlock() {
            SpongeObjective spongeObjective = ((ObjectiveBridge)this.objective).bridge$getSpongeObjective();
            spongeObjective.findScore(this.holder.getScoreboardName()).ifPresent(spongeScore -> {
                if (spongeScore.isLocked()) {
                    spongeScore.setLocked(false);
                }
            });
            this.access.unlock();
        }

        public void lock() {
            SpongeObjective spongeObjective = ((ObjectiveBridge)this.objective).bridge$getSpongeObjective();
            spongeObjective.findScore(this.holder.getScoreboardName()).ifPresent(spongeScore -> {
                if (!spongeScore.isLocked()) {
                    spongeScore.setLocked(true);
                }
            });
            this.access.lock();
        }

        public void display(@Nullable Component var1) {
            SpongeObjective spongeObjective = ((ObjectiveBridge)this.objective).bridge$getSpongeObjective();
            spongeObjective.findScore(this.holder.getScoreboardName()).ifPresent(spongeScore -> {
                if (spongeScore.display().isEmpty() && var1 == null) {
                    return;
                }
                if (var1 == null) {
                    spongeScore.setDisplay(null);
                    return;
                }
                net.kyori.adventure.text.Component component = SpongeAdventure.asAdventure(var1);
                if (Objects.equals(spongeScore.display().orElse(null), component)) {
                    return;
                }
                spongeScore.setDisplay(component);
            });
            this.access.display(var1);
        }

        public void numberFormatOverride(@Nullable NumberFormat var1) {
            this.access.numberFormatOverride(var1);
        }
    }
}

