/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.ban;

import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.ban.BanTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.players.IpBanListAccessor;
import org.spongepowered.common.accessor.server.players.StoredUserListAccessor;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.UserListUtil;

@Singleton
public final class SpongeBanService
implements BanService {
    @Override
    public CompletableFuture<Collection<? extends Ban>> bans() {
        Collection<Ban.Profile> bans = this.profileBans().join();
        Collection<Ban.IP> ipBans = this.ipBans().join();
        ArrayList<Ban> list = new ArrayList<Ban>(bans.size() + ipBans.size());
        list.addAll(bans);
        list.addAll(ipBans);
        return CompletableFuture.completedFuture(Collections.unmodifiableCollection(list));
    }

    @Override
    public CompletableFuture<Collection<Ban.Profile>> profileBans() {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return CompletableFuture.completedFuture(Collections.unmodifiableCollection(new ArrayList(accessor.accessor$map().values())));
    }

    @Override
    public CompletableFuture<Collection<Ban.IP>> ipBans() {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return CompletableFuture.completedFuture(Collections.unmodifiableCollection(new ArrayList(accessor.accessor$map().values())));
    }

    @Override
    public CompletableFuture<Optional<Ban.Profile>> find(GameProfile profile) {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return CompletableFuture.completedFuture(Optional.ofNullable((Ban.Profile)accessor.accessor$map().get(accessor.invoker$getKeyForUser(SpongeGameProfile.toMcProfile(profile)))));
    }

    @Override
    public CompletableFuture<Optional<Ban.IP>> find(InetAddress address) {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return CompletableFuture.completedFuture(Optional.ofNullable((Ban.IP)accessor.accessor$map().get(accessor.invoker$getKeyForUser(((IpBanListAccessor)((Object)accessor)).invoker$getIpFromAddress(new InetSocketAddress(address, 0))))));
    }

    public boolean isBanned(GameProfile profile) {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return accessor.accessor$map().containsKey(accessor.invoker$getKeyForUser(SpongeGameProfile.toMcProfile(profile)));
    }

    public boolean isBanned(InetAddress address) {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return accessor.accessor$map().containsKey(accessor.invoker$getKeyForUser(((IpBanListAccessor)((Object)accessor)).invoker$getIpFromAddress(new InetSocketAddress(address, 0))));
    }

    @Override
    public CompletableFuture<Boolean> pardon(GameProfile profile) {
        CompletableFuture<Optional<Ban.Profile>> ban = this.find(profile);
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return ban.thenCompose(result -> result.map(this::remove).orElse(CompletableFuture.completedFuture(false)));
    }

    @Override
    public CompletableFuture<Boolean> pardon(InetAddress address) {
        CompletableFuture<Optional<Ban.IP>> ban = this.find(address);
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return ban.thenCompose(result -> result.map(this::remove).orElse(CompletableFuture.completedFuture(false)));
    }

    @Override
    public CompletableFuture<Boolean> remove(Ban ban) {
        if (!this.hasBan(ban)) {
            return CompletableFuture.completedFuture(false);
        }
        if (ban.type().equals(BanTypes.PROFILE.get())) {
            return Sponge.server().userManager().loadOrCreate(((Ban.Profile)ban).profile().uuid()).thenApplyAsync(user -> {
                Sponge.eventManager().post(SpongeEventFactory.createPardonUserEvent(PhaseTracker.getCauseStackManager().currentCause(), (Ban.Profile)ban, user));
                UserListUtil.removeEntry(this.getUserBanList(), SpongeGameProfile.toMcProfile(((Ban.Profile)ban).profile()));
                return true;
            }, (Executor)((MinecraftServerBridge)SpongeCommon.server()).bridge$spongeMainThreadExecutor());
        }
        if (ban.type().equals(BanTypes.IP.get())) {
            Sponge.eventManager().post(SpongeEventFactory.createPardonIpEvent(PhaseTracker.getCauseStackManager().currentCause(), (Ban.IP)ban));
            InetSocketAddress inetSocketAddress = new InetSocketAddress(((Ban.IP)ban).address(), 0);
            UserListUtil.removeEntry(this.getIPBanList(), ((IpBanListAccessor)this.getIPBanList()).invoker$getIpFromAddress(inetSocketAddress));
            return CompletableFuture.completedFuture(true);
        }
        throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.type()));
    }

    @Override
    public CompletableFuture<Optional<? extends Ban>> add(Ban ban) {
        if (ban.type().equals(BanTypes.PROFILE.get())) {
            return Sponge.server().userManager().loadOrCreate(((Ban.Profile)ban).profile().uuid()).thenApplyAsync(user -> {
                Sponge.eventManager().post(SpongeEventFactory.createBanUserEvent(PhaseTracker.getCauseStackManager().currentCause(), (Ban.Profile)ban, user));
                return Optional.ofNullable((Ban)UserListUtil.addEntry(this.getUserBanList(), (StoredUserEntry)ban));
            }, (Executor)((MinecraftServerBridge)SpongeCommon.server()).bridge$spongeMainThreadExecutor());
        }
        if (!ban.type().equals(BanTypes.IP.get())) {
            throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.type()));
        }
        Sponge.eventManager().post(SpongeEventFactory.createBanIpEvent(PhaseTracker.getCauseStackManager().currentCause(), (Ban.IP)ban));
        Ban prevBan = (Ban)UserListUtil.addEntry(this.getIPBanList(), (StoredUserEntry)ban);
        return CompletableFuture.completedFuture(Optional.ofNullable(prevBan));
    }

    public boolean hasBan(Ban ban) {
        if (ban.type().equals(BanTypes.PROFILE.get())) {
            return this.isBanned(((Ban.Profile)ban).profile());
        }
        if (ban.type().equals(BanTypes.IP.get())) {
            return this.isBanned(((Ban.IP)ban).address());
        }
        throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.type()));
    }

    private UserBanList getUserBanList() {
        return SpongeCommon.server().getPlayerList().getBans();
    }

    private IpBanList getIPBanList() {
        return SpongeCommon.server().getPlayerList().getIpBans();
    }
}

