/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.StoredUserEntry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.service.server.permission.MemorySubjectData;
import org.spongepowered.common.service.server.permission.OpLevelCollection;
import org.spongepowered.common.service.server.permission.SingleParentMemorySubjectData;
import org.spongepowered.common.service.server.permission.SpongePermissionService;
import org.spongepowered.common.service.server.permission.SpongeSubject;
import org.spongepowered.common.service.server.permission.UserCollection;
import org.spongepowered.common.util.Preconditions;

public class UserSubject
extends SpongeSubject {
    private final GameProfile player;
    private final MemorySubjectData data;
    private final UserCollection collection;

    public UserSubject(final GameProfile player, final UserCollection users) {
        this.player = Objects.requireNonNull(player);
        this.data = new SingleParentMemorySubjectData(this){

            @Override
            public SubjectReference parent() {
                return users.getService().getGroupForOpLevel(UserSubject.this.getOpLevel()).asSubjectReference();
            }

            @Override
            public void setParent(SubjectReference parent) {
                int opLevel;
                if (parent == null) {
                    opLevel = 0;
                } else {
                    if (!(parent.resolve().join() instanceof OpLevelCollection.OpLevelSubject)) {
                        return;
                    }
                    opLevel = ((OpLevelCollection.OpLevelSubject)((Object)parent)).opLevel();
                }
                if (opLevel > 0) {
                    SpongePermissionService.getOps().add((StoredUserEntry)new ServerOpListEntry(player, opLevel, false));
                } else {
                    SpongePermissionService.getOps().remove((Object)player);
                }
            }
        };
        this.collection = users;
    }

    @Override
    public String identifier() {
        return this.player.getId().toString();
    }

    @Override
    public Optional<String> friendlyIdentifier() {
        return Optional.of(this.player.getName());
    }

    @Override
    public Optional<?> associatedObject() {
        if (!Sponge.isServerAvailable()) {
            return Optional.empty();
        }
        return Sponge.server().player(this.player.getId());
    }

    int getOpLevel() {
        Preconditions.checkState(Sponge.isServerAvailable(), "Server is not available!");
        ServerOpListEntry entry = (ServerOpListEntry)SpongePermissionService.getOps().get((Object)this.player);
        if (entry == null) {
            return SpongeCommon.server().getPlayerList().isOp(this.player) ? SpongeCommon.server().getOperatorUserPermissionLevel() : 0;
        }
        return entry.getLevel();
    }

    @Override
    public SubjectCollection containingCollection() {
        return this.collection;
    }

    @Override
    public MemorySubjectData subjectData() {
        return this.data;
    }

    @Override
    public PermissionService service() {
        return this.collection.getService();
    }

    @Override
    public Tristate permissionValue(String permission, Cause cause) {
        Tristate ret = super.permissionValue(permission, cause);
        if (ret == Tristate.UNDEFINED) {
            ret = this.dataPermissionValue(this.collection.defaults().subjectData(), permission);
        }
        if (ret == Tristate.UNDEFINED) {
            ret = this.dataPermissionValue(this.collection.getService().defaults().subjectData(), permission);
        }
        if (ret == Tristate.UNDEFINED && this.getOpLevel() >= SpongePermissionService.getServerOpLevel()) {
            ret = Tristate.TRUE;
        }
        return ret;
    }

    @Override
    public Optional<String> option(String option, Cause cause) {
        Optional<String> ret = super.option(option, cause);
        if (!ret.isPresent()) {
            ret = this.dataOptionValue(this.collection.defaults().subjectData(), option);
        }
        if (!ret.isPresent()) {
            ret = this.dataOptionValue(this.collection.getService().defaults().subjectData(), option);
        }
        return ret;
    }
}

