/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.carver;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.carver.Carver;
import org.spongepowered.api.world.generation.carver.CarverTemplate;
import org.spongepowered.api.world.generation.carver.CarverType;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeCarverTemplate
extends Record
implements CarverTemplate {
    private final ResourceKey key;
    private final ConfiguredWorldCarver<?> representedCarver;
    private final DataPack<CarverTemplate> pack;

    public SpongeCarverTemplate(ResourceKey key, ConfiguredWorldCarver<?> representedCarver, DataPack<CarverTemplate> pack) {
        this.key = key;
        this.representedCarver = representedCarver;
        this.pack = pack;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeCarverTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Carver:\n" + serialized, e);
        }
    }

    @Override
    public Carver carver() {
        return (Carver)this.representedCarver;
    }

    public static JsonElement encode(Codec<ConfiguredWorldCarver<?>> codec, ConfiguredWorldCarver<?> carver, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (JsonElement)codec.encodeStart((DynamicOps)ops, carver).getOrThrow(false, e -> {});
    }

    public static JsonElement encode(CarverTemplate template, RegistryAccess registryAccess) {
        return SpongeCarverTemplate.encode(ConfiguredWorldCarver.DIRECT_CODEC, (ConfiguredWorldCarver)template.carver(), registryAccess);
    }

    public static ConfiguredWorldCarver<?> decode(Codec<ConfiguredWorldCarver<?>> codec, JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (ConfiguredWorldCarver)codec.parse((DynamicOps)ops, (Object)json).getOrThrow(false, e -> {});
    }

    public static CarverTemplate decode(DataPack<CarverTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        ConfiguredWorldCarver<?> parsed = SpongeCarverTemplate.decode(ConfiguredWorldCarver.DIRECT_CODEC, packEntry, registryAccess);
        return new SpongeCarverTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeCarverTemplate.class, "key;representedCarver;pack", "key", "representedCarver", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeCarverTemplate.class, "key;representedCarver;pack", "key", "representedCarver", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeCarverTemplate.class, "key;representedCarver;pack", "key", "representedCarver", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public ConfiguredWorldCarver<?> representedCarver() {
        return this.representedCarver;
    }

    @Override
    public DataPack<CarverTemplate> pack() {
        return this.pack;
    }

    public static class BuilderImpl
    extends AbstractDataPackEntryBuilder<Carver, CarverTemplate, CarverTemplate.Builder>
    implements CarverTemplate.Builder {
        private @Nullable WorldCarver<?> type;
        private @Nullable CarverConfiguration config;

        @Override
        public Function<CarverTemplate, Carver> valueExtractor() {
            return CarverTemplate::carver;
        }

        @Override
        public CarverTemplate.Builder reset() {
            this.type = null;
            this.config = null;
            this.key = null;
            this.pack = DataPacks.CARVER;
            return this;
        }

        @Override
        public CarverTemplate.Builder type(CarverType type) {
            this.type = (WorldCarver)type;
            return this;
        }

        @Override
        public CarverTemplate.Builder fromValue(Carver carver) {
            this.type(carver.type());
            this.config = ((ConfiguredWorldCarver)carver).config();
            return this;
        }

        @Override
        public CarverTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            ConfiguredWorldCarver<?> carver = SpongeCarverTemplate.decode(ConfiguredWorldCarver.DIRECT_CODEC, json, (RegistryAccess)SpongeCommon.server().registryAccess());
            this.fromValue((Carver)carver);
            return this;
        }

        @Override
        protected CarverTemplate build0() {
            ConfiguredWorldCarver carver = new ConfiguredWorldCarver(this.type, this.config);
            return new SpongeCarverTemplate(this.key, carver, this.pack);
        }
    }
}

