/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;

public final class PortalHelper {
    private static final BlockState northEndFrame = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)EndPortalFrameBlock.FACING, (Comparable)Direction.NORTH);
    private static final BlockState southEndFrame = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)EndPortalFrameBlock.FACING, (Comparable)Direction.SOUTH);
    private static final BlockState eastEndFrame = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)EndPortalFrameBlock.FACING, (Comparable)Direction.EAST);
    private static final BlockState westEndFrame = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)EndPortalFrameBlock.FACING, (Comparable)Direction.WEST);
    private static final BlockState endPortal = Blocks.END_PORTAL.defaultBlockState();

    public static void generateEndPortal(ServerLevel world, int x, int y, int z, boolean placePortalBlocks) {
        BlockPos.MutableBlockPos origin = new BlockPos.MutableBlockPos(x, y, z);
        for (int bx = 0; bx < 5; ++bx) {
            for (int by = 0; by < 5; ++by) {
                origin.set(x + bx, y, z + by);
                if (bx == 0 && by > 0 && by < 4) {
                    world.setBlock((BlockPos)origin, (BlockState)southEndFrame.setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(world.random.nextFloat() > 0.9f)), 2);
                    continue;
                }
                if (bx == 1 || bx == 2 || bx == 3) {
                    if (by == 0) {
                        world.setBlock((BlockPos)origin, (BlockState)eastEndFrame.setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(world.random.nextFloat() > 0.9f)), 2);
                        continue;
                    }
                    if (by == 4) {
                        world.setBlock((BlockPos)origin, (BlockState)westEndFrame.setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(world.random.nextFloat() > 0.9f)), 2);
                        continue;
                    }
                    if (!placePortalBlocks) continue;
                    world.setBlock((BlockPos)origin, endPortal, 2);
                    continue;
                }
                if (bx != 4 || by <= 0 || by >= 4) continue;
                world.setBlock((BlockPos)origin, (BlockState)northEndFrame.setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(world.random.nextFloat() > 0.9f)), 2);
            }
        }
    }

    public static void generateNetherPortal(ServerLevel world, int x, int y, int z, Direction.Axis axis, boolean placePortalBlocks) {
        BlockPos portalPos = new BlockPos(x, y, z);
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = world.getWorldBorder();
        int i = world.getHeight() - 1;
        BlockPos.MutableBlockPos blockpos$mutable = portalPos.mutable();
        for (BlockPos.MutableBlockPos blockpos$mutable1 : BlockPos.spiralAround((BlockPos)portalPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, world.getHeight(Heightmap.Types.MOTION_BLOCKING, blockpos$mutable1.getX(), blockpos$mutable1.getZ()));
            boolean k = true;
            if (!worldborder.isWithinBounds((BlockPos)blockpos$mutable1) || !worldborder.isWithinBounds((BlockPos)blockpos$mutable1.move(direction, 1))) continue;
            blockpos$mutable1.move(direction.getOpposite(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                blockpos$mutable1.setY(l);
                if (!world.isEmptyBlock((BlockPos)blockpos$mutable1)) continue;
                int i1 = l;
                while (l > 0 && world.isEmptyBlock((BlockPos)blockpos$mutable1.move(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutable1.setY(l);
                if (!PortalHelper.canHostFrame(world, (BlockPos)blockpos$mutable1, blockpos$mutable, direction, 0)) continue;
                double d2 = portalPos.distSqr((Vec3i)blockpos$mutable1);
                if (PortalHelper.canHostFrame(world, (BlockPos)blockpos$mutable1, blockpos$mutable, direction, -1) && PortalHelper.canHostFrame(world, (BlockPos)blockpos$mutable1, blockpos$mutable, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutable1.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutable1.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(portalPos.getX(), Mth.clamp((int)portalPos.getY(), (int)70, (int)(world.getHeight() - 10)), portalPos.getZ()).immutable();
            Direction direction1 = direction.getClockWise();
            if (!worldborder.isWithinBounds(blockpos)) {
                return;
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        BlockState blockstate1 = i3 < 0 ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.AIR.defaultBlockState();
                        blockpos$mutable.setWithOffset((Vec3i)blockpos, k2 * direction.getStepX() + l1 * direction1.getStepX(), i3, k2 * direction.getStepZ() + l1 * direction1.getStepZ());
                        world.setBlockAndUpdate((BlockPos)blockpos$mutable, blockstate1);
                    }
                }
            }
        }
        for (int k1 = -1; k1 < 3; ++k1) {
            for (int i2 = -1; i2 < 4; ++i2) {
                if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                blockpos$mutable.setWithOffset((Vec3i)blockpos, k1 * direction.getStepX(), i2, k1 * direction.getStepZ());
                world.setBlock((BlockPos)blockpos$mutable, Blocks.OBSIDIAN.defaultBlockState(), 3);
            }
        }
        if (placePortalBlocks) {
            BlockState blockstate = (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue((Property)NetherPortalBlock.AXIS, (Comparable)axis);
            for (int j2 = 0; j2 < 2; ++j2) {
                for (int l2 = 0; l2 < 3; ++l2) {
                    blockpos$mutable.setWithOffset((Vec3i)blockpos, j2 * direction.getStepX(), l2, j2 * direction.getStepZ());
                    world.setBlock((BlockPos)blockpos$mutable, blockstate, 18);
                }
            }
        }
    }

    private static boolean canHostFrame(ServerLevel world, BlockPos p_242955_1_, BlockPos.MutableBlockPos p_242955_2_, Direction p_242955_3_, int p_242955_4_) {
        Direction direction = p_242955_3_.getClockWise();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                p_242955_2_.setWithOffset((Vec3i)p_242955_1_, p_242955_3_.getStepX() * i + direction.getStepX() * p_242955_4_, j, p_242955_3_.getStepZ() * i + direction.getStepZ() * p_242955_4_);
                if (j < 0 && !world.getBlockState((BlockPos)p_242955_2_).isSolid()) {
                    return false;
                }
                if (j < 0 || world.isEmptyBlock((BlockPos)p_242955_2_)) continue;
                return false;
            }
        }
        return true;
    }
}

