/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.storage;

import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeChunkLayout
implements ChunkLayout {
    public static final SpongeChunkLayout INSTANCE = new SpongeChunkLayout();
    private final Vector3i size;
    private final Vector3i mask;
    private final Vector3i spaceMin;
    private final Vector3i spaceMax;
    private final Vector3i spaceSize;

    public SpongeChunkLayout(int minY, int height) {
        this.size = new Vector3i(16, height, 16);
        this.mask = this.size.sub(1, 1, 1);
        this.spaceMax = new Vector3i(Constants.World.BLOCK_MAX.x(), minY + height, Constants.World.BLOCK_MAX.z()).sub(1, 1, 1);
        this.spaceMin = new Vector3i(Constants.World.BLOCK_MIN.x(), minY, Constants.World.BLOCK_MIN.z());
        this.spaceSize = this.spaceMax.sub(this.spaceMin).add(1, 1, 1);
    }

    private SpongeChunkLayout() {
        this(-64, 384);
    }

    public Vector3i getMask() {
        return this.mask;
    }

    @Override
    public Vector3i chunkSize() {
        return this.size;
    }

    @Override
    public Vector3i spaceMax() {
        return this.spaceMax;
    }

    @Override
    public Vector3i spaceMin() {
        return this.spaceMin;
    }

    @Override
    public Vector3i spaceSize() {
        return this.spaceSize;
    }

    @Override
    public Vector3i spaceOrigin() {
        return Vector3i.ZERO;
    }

    @Override
    public boolean isInChunk(int x, int y, int z) {
        return (x & ~this.mask.x()) == 0 && (y & ~this.mask.y()) == 0 && (z & ~this.mask.z()) == 0;
    }

    @Override
    public boolean isInChunk(int wx, int wy, int wz, int cx, int cy, int cz) {
        return this.isInChunk(wx - (cx << 4), wy - Math.floorDiv(cy - this.spaceMin.y(), this.size.y()), wz - (cz << 4));
    }

    @Override
    public Vector3i forceToChunk(int x, int y, int z) {
        return new Vector3i(x >> 4, Math.floorDiv(y - this.spaceMin.y(), this.size.y()), z >> 4);
    }

    @Override
    public Vector3i forceToWorld(int x, int y, int z) {
        return new Vector3i(x << 4, y * this.size.y() + this.spaceMin.y(), z << 4);
    }
}

