/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.weather;

import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.api.world.weather.WeatherTypes;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.world.weather.SpongeWeatherType;

public final class SpongeWeather
implements Weather {
    private final SpongeWeatherType type;
    private final Ticks remainingDuration;
    private final Ticks runningDuration;

    public SpongeWeather(SpongeWeatherType type, Ticks remainingDuration, Ticks runningDuration) {
        this.type = type;
        this.remainingDuration = remainingDuration;
        this.runningDuration = runningDuration;
    }

    public static Weather of(ServerLevelData levelData) {
        boolean thundering = levelData.isThundering();
        if (thundering) {
            Ticks thunderTime = SpongeTicks.ticksOrInfinite(levelData.getThunderTime());
            return new SpongeWeather((SpongeWeatherType)WeatherTypes.THUNDER.get(), thunderTime, thunderTime.isInfinite() ? thunderTime : new SpongeTicks(6000L - thunderTime.ticks()));
        }
        boolean raining = levelData.isRaining();
        if (raining) {
            Ticks rainTime = SpongeTicks.ticksOrInfinite(levelData.getRainTime());
            return new SpongeWeather((SpongeWeatherType)WeatherTypes.RAIN.get(), rainTime, rainTime.isInfinite() ? rainTime : new SpongeTicks(6000L - rainTime.ticks()));
        }
        Ticks clearWeatherTime = SpongeTicks.ticksOrInfinite(levelData.getClearWeatherTime());
        return new SpongeWeather((SpongeWeatherType)WeatherTypes.CLEAR.get(), clearWeatherTime, clearWeatherTime.isInfinite() ? clearWeatherTime : new SpongeTicks(6000L - clearWeatherTime.ticks()));
    }

    public static void apply(ServerLevelData levelData, Weather weather) {
        int time = SpongeTicks.toSaturatedIntOrInfinite(weather.remainingDuration());
        WeatherType type = weather.type();
        if (type == WeatherTypes.CLEAR.get()) {
            levelData.setClearWeatherTime(time);
            levelData.setRaining(false);
            levelData.setRainTime(0);
            levelData.setThundering(false);
            levelData.setThunderTime(0);
        } else if (type == WeatherTypes.RAIN.get()) {
            levelData.setRaining(true);
            levelData.setRainTime(time);
            levelData.setThundering(false);
            levelData.setThunderTime(0);
            levelData.setClearWeatherTime(0);
        } else if (type == WeatherTypes.THUNDER.get()) {
            levelData.setRaining(true);
            levelData.setRainTime(time);
            levelData.setThundering(true);
            levelData.setThunderTime(time);
            levelData.setClearWeatherTime(0);
        }
    }

    @Override
    public WeatherType type() {
        return this.type;
    }

    @Override
    public Ticks remainingDuration() {
        return this.remainingDuration;
    }

    @Override
    public Ticks runningDuration() {
        return this.runningDuration;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Universe.Weather.TYPE, this.type.key(RegistryTypes.WEATHER_TYPE)).set(Constants.Universe.Weather.REMAINING_DURATION, this.remainingDuration.ticks()).set(Constants.Universe.Weather.RUNNING_DURATION, this.runningDuration.ticks());
    }

    public static class FactoryImpl
    implements Weather.Factory {
        @Override
        public Weather of(WeatherType type, Ticks remainingDuration, Ticks runningDuration) {
            return new SpongeWeather((SpongeWeatherType)type, remainingDuration, runningDuration);
        }
    }
}

