/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch;

import cpw.mods.modlauncher.Launcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.fusesource.jansi.AnsiConsole;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.plugin.builtin.StandardEnvironment;
import org.spongepowered.vanilla.applaunch.AppCommandLine;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginPlatform;
import org.spongepowered.vanilla.applaunch.util.ArgumentList;

public final class Main {
    private final VanillaPluginPlatform pluginPlatform = (VanillaPluginPlatform)AppLaunch.setPluginPlatform(new VanillaPluginPlatform(new StandardEnvironment()));
    private final Path[] extraPaths;

    public Main(Path[] extraPaths) {
        this.extraPaths = extraPaths;
    }

    public static void main(String[] args) throws Exception {
        Main.main(args, new Path[0]);
    }

    public static void main(String[] args, Path[] extraPaths) throws Exception {
        AppCommandLine.configure(args);
        new Main(extraPaths).run();
    }

    public void run() throws IOException {
        String implementationVersion = StandardEnvironment.class.getPackage().getImplementationVersion();
        this.pluginPlatform.setVersion(implementationVersion == null ? "dev" : implementationVersion);
        this.pluginPlatform.setBaseDirectory(AppCommandLine.gameDirectory);
        Path modsDirectory = AppCommandLine.gameDirectory.resolve("mods");
        if (Files.notExists(modsDirectory, new LinkOption[0])) {
            Files.createDirectories(modsDirectory, new FileAttribute[0]);
        }
        Path pluginsDirectory = AppCommandLine.gameDirectory.resolve("plugins");
        ArrayList<Path> pluginDirectories = new ArrayList<Path>();
        pluginDirectories.add(modsDirectory);
        if (Files.exists(pluginsDirectory, new LinkOption[0])) {
            pluginDirectories.add(pluginsDirectory);
        }
        this.pluginPlatform.setPluginDirectories(pluginDirectories);
        this.pluginPlatform.setMetadataFilePath("META-INF/sponge_plugins.json");
        this.pluginPlatform.getStandardEnvironment().blackboard().getOrCreate(VanillaPluginPlatform.EXTRA_TRANSFORMABLE_PATHS, () -> Collections.unmodifiableList(Arrays.asList(this.extraPaths)));
        AppLaunch.logger().info("Transitioning to ModLauncher, please wait...");
        ArgumentList lst = ArgumentList.from(AppCommandLine.RAW_ARGS);
        Launcher.main((String[])lst.getArguments());
    }

    static {
        AnsiConsole.systemInstall();
    }
}

