/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.launch;

import com.google.inject.Stage;
import java.util.Queue;
import net.minecraft.server.Bootstrap;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.Lifecycle;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginPlatform;
import org.spongepowered.vanilla.applaunch.util.MixinLoggerInjector;
import org.spongepowered.vanilla.launch.VanillaBootstrap;
import org.spongepowered.vanilla.launch.VanillaLaunch;

public class IntegrationTestLaunch
extends VanillaLaunch {
    private final boolean isServer;
    private Queue<String> capturedMessages;

    protected IntegrationTestLaunch(VanillaPluginPlatform pluginPlatform, boolean isServer) {
        super(pluginPlatform, Stage.DEVELOPMENT);
        this.isServer = isServer;
    }

    public static void launch(VanillaPluginPlatform pluginPlatform, Boolean isServer, String[] args) {
        IntegrationTestLaunch launcher = new IntegrationTestLaunch(pluginPlatform, isServer);
        Launch.setInstance(launcher);
        launcher.launchPlatform(args);
    }

    @Override
    public boolean dedicatedServer() {
        return this.isServer;
    }

    @Override
    protected void performBootstrap(String[] args) {
        this.logger().info("Running integration tests...");
        this.capturedMessages = MixinLoggerInjector.captureLogger();
        VanillaBootstrap.perform("integration tests", this::performIntegrationTests);
    }

    private void performIntegrationTests() {
        try {
            Bootstrap.bootStrap();
            Bootstrap.validate();
            Lifecycle lifecycle = ((Launch)Launch.instance()).lifecycle();
            lifecycle.establishDataProviders();
            lifecycle.callRegisterDataEvent();
            this.logger().info("Performing Mixin audit");
            ((Launch)Launch.instance()).auditMixins();
        }
        finally {
            Queue<String> capturedMessages = this.capturedMessages;
            if (capturedMessages.peek() != null) {
                String message;
                this.logger().error("Invalid conditions were detected while applying mixins (see MixinLoggerInjector):");
                while ((message = capturedMessages.poll()) != null) {
                    this.logger().error("- {}", (Object)message);
                }
                System.exit(1);
            }
        }
        this.logger().info("Testing complete, goodbye!");
        SpongeCommon.game().asyncScheduler().close();
        System.exit(0);
    }
}

