/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.network.ServerLoginPacketListenerImplBridge;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.TransactionStore;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginPacketListenerImplMixin_Vanilla
implements ServerLoginPacketListener {
    @Shadow
    @Final
    static Logger LOGGER;
    @Shadow
    @Final
    MinecraftServer server;
    @Shadow
    private ServerLoginPacketListenerImpl.State state;
    @Shadow
    @Final
    Connection connection;
    @Shadow
    @Final
    private byte[] challenge;
    @Shadow
    @Nullable
    String requestedUsername;
    private static final int HANDSHAKE_NOT_STARTED = 0;
    private static final int HANDSHAKE_CLIENT_TYPE = 1;
    private static final int HANDSHAKE_SYNC_CHANNEL_REGISTRATIONS = 2;
    private static final int HANDSHAKE_CHANNEL_REGISTRATION = 3;
    private static final int HANDSHAKE_SYNC_PLUGIN_DATA = 4;
    private int impl$handshakeState = 0;

    @Shadow
    public abstract void shadow$disconnect(Component var1);

    @Shadow
    abstract void shadow$startClientVerification(GameProfile var1);

    @Inject(method={"handleCustomQueryPacket"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onResponsePayload(ServerboundCustomQueryAnswerPacket packet, CallbackInfo ci) {
        ci.cancel();
        SpongeChannelManager channelRegistry = (SpongeChannelManager)Sponge.channelManager();
        this.server.execute(() -> channelRegistry.handleLoginResponsePayload((EngineConnection)((Object)this), packet));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void impl$onTick(CallbackInfo ci) {
        if (this.state == ServerLoginPacketListenerImpl.State.NEGOTIATING) {
            TransactionStore store;
            ServerSideConnection connection = (ServerSideConnection)((Object)this);
            if (this.impl$handshakeState == 0) {
                this.impl$handshakeState = 1;
                ((SpongeChannelManager)Sponge.channelManager()).requestClientType(connection).thenAccept(result -> {
                    this.impl$handshakeState = 2;
                });
            } else if (this.impl$handshakeState == 2) {
                this.impl$handshakeState = 3;
                ((SpongeChannelManager)Sponge.channelManager()).sendLoginChannelRegistry(connection).thenAccept(result -> {
                    Cause cause = Cause.of(EventContext.empty(), this);
                    ServerSideConnectionEvent.Handshake event = SpongeEventFactory.createServerSideConnectionEventHandshake(cause, connection);
                    SpongeCommon.post(event);
                    this.impl$handshakeState = 4;
                });
            } else if (this.impl$handshakeState == 4 && (store = ConnectionUtil.getTransactionStore(connection)).isEmpty()) {
                this.state = ServerLoginPacketListenerImpl.State.VERIFYING;
            }
        }
    }

    @Overwrite
    public void handleKey(ServerboundKeyPacket packet) {
        String $$5;
        Validate.validState((this.state == ServerLoginPacketListenerImpl.State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey $$1 = this.server.getKeyPair().getPrivate();
            if (!packet.isChallengeValid(this.challenge, $$1)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey $$2 = packet.getSecretKey($$1);
            Cipher $$3 = Crypt.getCipher((int)2, (Key)$$2);
            Cipher $$4 = Crypt.getCipher((int)1, (Key)$$2);
            $$5 = new BigInteger(Crypt.digestData((String)"", (PublicKey)this.server.getKeyPair().getPublic(), (SecretKey)$$2)).toString(16);
            this.state = ServerLoginPacketListenerImpl.State.AUTHENTICATING;
            this.connection.setEncryptionKey($$3, $$4);
        }
        catch (CryptException var7) {
            throw new IllegalStateException("Protocol error", var7);
        }
        ((ServerLoginPacketListenerImplBridge)((Object)this)).bridge$getExecutor().submit(() -> {
            String username = Objects.requireNonNull(this.requestedUsername, "Player name not initialized");
            try {
                ProfileResult $$1 = this.server.getSessionService().hasJoinedServer(username, $$5, this.vanilla$getAddress());
                if ($$1 != null) {
                    GameProfile $$2 = $$1.profile();
                    LOGGER.info("UUID of player {} is {}", (Object)$$2.getName(), (Object)$$2.getId());
                    this.shadow$startClientVerification($$2);
                } else if (this.server.isSingleplayer()) {
                    LOGGER.warn("Failed to verify username but will let them in anyway!");
                    this.shadow$startClientVerification(UUIDUtil.createOfflineProfile((String)username));
                } else {
                    this.shadow$disconnect((Component)Component.translatable((String)"multiplayer.disconnect.unverified_username"));
                    LOGGER.error("Username '{}' tried to join with an invalid session", (Object)username);
                }
            }
            catch (AuthenticationUnavailableException var4) {
                if (this.server.isSingleplayer()) {
                    LOGGER.warn("Authentication servers are down but will let them in anyway!");
                    this.shadow$startClientVerification(UUIDUtil.createOfflineProfile((String)username));
                }
                this.shadow$disconnect((Component)Component.translatable((String)"multiplayer.disconnect.authservers_down"));
                LOGGER.error("Couldn't verify username because servers are unavailable");
            }
        });
    }

    @Nullable
    private InetAddress vanilla$getAddress() {
        SocketAddress $$0 = this.connection.getRemoteAddress();
        return this.server.getPreventProxyConnections() && $$0 instanceof InetSocketAddress ? ((InetSocketAddress)$$0).getAddress() : null;
    }
}

