/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.server.network.protocol.common;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerboundCustomPayloadPacket.class})
public abstract class ServerboundCustomPayloadPacketMixin_Vanilla {
    @Shadow
    @Final
    private static int MAX_PAYLOAD_SIZE;

    @Inject(method={"readPayload"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/common/ServerboundCustomPayloadPacket;readUnknownPayload(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/network/FriendlyByteBuf;)Lnet/minecraft/network/protocol/common/custom/DiscardedPayload;")}, cancellable=true)
    private static void impl$onReadUnknownPayload(final ResourceLocation id, FriendlyByteBuf buf, CallbackInfoReturnable<CustomPacketPayload> cir) {
        int readableBytes = buf.readableBytes();
        if (readableBytes < 0 || readableBytes > MAX_PAYLOAD_SIZE) {
            throw new IllegalArgumentException("Payload may not be larger than " + MAX_PAYLOAD_SIZE + " bytes");
        }
        final FriendlyByteBuf payload = new FriendlyByteBuf(buf.readBytes(readableBytes));
        cir.setReturnValue((Object)new CustomPacketPayload(){

            public void write(FriendlyByteBuf buf) {
                buf.writeBytes(payload.copy());
            }

            public ResourceLocation id() {
                return id;
            }
        });
    }
}

