/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.server.packs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.plugin.PluginContainer;

public final class PluginPackResources
extends AbstractPackResources {
    private final PluginContainer container;
    private final PackMetadataSection metadata;
    private final @Nullable Supplier<FileSystem> fileSystem;
    private final File file = new File("sponge_plugin_pack");

    public PluginPackResources(String name, PluginContainer container, @Nullable Supplier<FileSystem> fileSystem) {
        super(name, false);
        this.container = container;
        this.metadata = new PackMetadataSection((Component)Component.literal((String)"Plugin Resources"), 6, Optional.empty());
        this.fileSystem = fileSystem;
    }

    public IoSupplier<InputStream> getRootResource(String ... var1) {
        String rawPath = String.join((CharSequence)"/", var1);
        return this.getResource(rawPath);
    }

    private IoSupplier<InputStream> getResource(String rawPath) {
        Optional uri = this.container.locateResource(URI.create(rawPath));
        if (uri.isEmpty()) {
            return null;
        }
        return () -> ((URI)uri.get()).toURL().openStream();
    }

    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation loc) {
        return this.getResource(String.format(Locale.ROOT, "%s/%s/%s", type.getDirectory(), loc.getNamespace(), loc.getPath()));
    }

    public void listResources(PackType type, String namespace, String path, PackResources.ResourceOutput out) {
        try {
            Path root = this.typeRoot(type);
            Path namespaceDir = root.resolve(namespace).toAbsolutePath();
            try (Stream<Path> stream = Files.walk(namespaceDir, new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(s -> !s.getFileName().toString().endsWith(".mcmeta")).map(namespaceDir::relativize).map(Object::toString).map(s -> new ResourceLocation(namespace, s)).forEach(loc -> out.accept(loc, this.getResource(type, (ResourceLocation)loc)));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean filterValidPath(String namespace, String path, Predicate<ResourceLocation> fileNameValidator) {
        try {
            ResourceLocation loc = ResourceLocation.tryBuild((String)namespace, (String)path);
            if (loc == null) {
                return false;
            }
            return fileNameValidator.test(loc);
        }
        catch (ResourceLocationException e) {
            return false;
        }
    }

    public <T> @Nullable T getMetadataSection(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer.getMetadataSectionName().equals("pack")) {
            return (T)this.metadata;
        }
        return null;
    }

    public Set<String> getNamespaces(PackType type) {
        block8: {
            Set<String> set;
            block9: {
                @Nullable Path root = this.typeRoot(type);
                if (root == null) break block8;
                Stream<Path> stream = Files.list(root);
                try {
                    set = stream.map(Path::getFileName).map(Object::toString).filter(s -> {
                        if (s.equals(s.toLowerCase(Locale.ROOT))) {
                            return true;
                        }
                        SpongeCommon.logger().warn("Pack: ignored non-lowercased namespace: {} in {}", s, (Object)root.toAbsolutePath().toString());
                        return false;
                    }).collect(Collectors.toSet());
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                stream.close();
            }
            return set;
        }
        return Collections.emptySet();
    }

    public void close() {
    }

    private @Nullable Path typeRoot(PackType type) throws IOException {
        if (this.fileSystem == null) {
            return null;
        }
        return this.fileSystem.get().getPath(type.getDirectory(), new String[0]);
    }
}

