/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.CopyableValueContainer;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.util.annotation.eventgen.TransformWith;

public interface DataManipulator
extends CopyableValueContainer {
    public static Immutable immutableOf(Iterable<? extends Value<?>> values) {
        return Sponge.game().factoryProvider().provide(Immutable.Factory.class).of(values);
    }

    public static Immutable immutableOf(ValueContainer valueContainer) {
        return Sponge.game().factoryProvider().provide(Immutable.Factory.class).of(valueContainer);
    }

    public static Immutable immutableOf() {
        return Sponge.game().factoryProvider().provide(Immutable.Factory.class).of();
    }

    public static Mutable mutableOf() {
        return Sponge.game().factoryProvider().provide(Mutable.Factory.class).of();
    }

    public static Mutable mutableOf(Iterable<? extends Value<?>> values) {
        return Sponge.game().factoryProvider().provide(Mutable.Factory.class).of(values);
    }

    public static Mutable mutableOf(ValueContainer valueContainer) {
        return Sponge.game().factoryProvider().provide(Mutable.Factory.class).of(valueContainer);
    }

    @Override
    @TransformWith
    public DataManipulator copy();

    public Mutable asMutableCopy();

    public Mutable asMutable();

    public Immutable asImmutable();

    public static interface Immutable
    extends DataManipulator {
        @Override
        default public Immutable copy() {
            return this;
        }

        @Override
        default public Immutable asImmutable() {
            return this;
        }

        default public <E> Immutable with(Key<? extends Value<E>> key, E value) {
            return this.asMutable().set(key, value).asImmutable();
        }

        default public Immutable without(Key<?> key) {
            return this.asMutable().remove(key).asImmutable();
        }

        default public <E> Immutable with(Value<E> value) {
            return this.with(value.key(), value.get());
        }

        default public <E> Immutable transform(Key<? extends Value<E>> key, Function<E, E> function) {
            Objects.requireNonNull(function, "function");
            return this.get(key).map(element -> this.with(key, Objects.requireNonNull(function.apply(element)))).orElse(this);
        }

        public static interface Factory {
            public Immutable of();

            public Immutable of(Iterable<? extends Value<?>> var1);

            public Immutable of(ValueContainer var1);
        }
    }

    public static interface Mutable
    extends DataManipulator {
        default public Mutable copyFrom(ValueContainer valueContainer, Predicate<Key<?>> predicate) {
            return this.copyFrom(valueContainer, MergeFunction.REPLACEMENT_PREFERRED, predicate);
        }

        public Mutable copyFrom(ValueContainer var1, MergeFunction var2, Predicate<Key<?>> var3);

        default public Mutable copyFrom(ValueContainer valueContainer, Key<?> first, Key<?> ... more) {
            return this.copyFrom(valueContainer, MergeFunction.REPLACEMENT_PREFERRED, first, more);
        }

        default public Mutable copyFrom(ValueContainer valueContainer, MergeFunction overlap, Key<?> first, Key<?> ... more) {
            return this.copyFrom(valueContainer, overlap, Stream.concat(Stream.of(first), Arrays.stream(more)).collect(Collectors.toUnmodifiableList()));
        }

        default public Mutable copyFrom(ValueContainer valueContainer, Iterable<Key<?>> keys) {
            return this.copyFrom(valueContainer, MergeFunction.REPLACEMENT_PREFERRED, keys);
        }

        public Mutable copyFrom(ValueContainer var1, MergeFunction var2, Iterable<Key<?>> var3);

        default public Mutable copyFrom(ValueContainer valueContainer) {
            return this.copyFrom(valueContainer, MergeFunction.REPLACEMENT_PREFERRED);
        }

        public Mutable copyFrom(ValueContainer var1, MergeFunction var2);

        public <E> Mutable set(Key<? extends Value<E>> var1, E var2);

        default public <E, V extends Value<E>> Mutable set(Supplier<Key<V>> key, E value) {
            return this.set(key.get(), value);
        }

        default public <E, V extends Value<E>> Mutable set(Supplier<Key<V>> key, Supplier<E> value) {
            return this.set(Objects.requireNonNull(key, "Key supplier cannot be null").get(), Objects.requireNonNull(value, "Value supplier cannot be null").get());
        }

        default public Mutable set(Value<?> value) {
            return this.set(value.key(), value.get());
        }

        default public Mutable set(Value<?> ... values) {
            for (Value<?> value : Objects.requireNonNull(values)) {
                this.set(Objects.requireNonNull(value, "A null value was provided!"));
            }
            return this;
        }

        default public Mutable set(Iterable<? extends Value<?>> values) {
            for (Value<?> value : Objects.requireNonNull(values)) {
                this.set(Objects.requireNonNull(value, "A null value was provided!"));
            }
            return this;
        }

        default public <E> Mutable transform(Key<? extends Value<E>> key, Function<E, E> function) {
            if (!this.supports(key)) {
                throw new IllegalArgumentException("The provided key is not supported: " + key.toString());
            }
            return this.set(key, Objects.requireNonNull(function.apply(this.get(key).get()), "The function can not be returning null!"));
        }

        public Mutable remove(Key<?> var1);

        @Override
        default public Mutable asMutable() {
            return this;
        }

        @Override
        public Mutable copy();

        public static interface Factory {
            public Mutable of();

            public Mutable of(Iterable<? extends Value<?>> var1);

            public Mutable of(ValueContainer var1);
        }
    }
}

