/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.type;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.tag.Tag;

public interface ToolRule {
    public static ToolRule minesAndDrops(List<BlockType> blocks, double speed) {
        return ToolRule.factory().minesAndDrops(blocks, speed);
    }

    public static ToolRule minesAndDrops(Tag<BlockType> blockTypeTag, double speed) {
        return ToolRule.factory().minesAndDrops(blockTypeTag, speed);
    }

    public static ToolRule deniesDrops(List<BlockType> blocks) {
        return ToolRule.factory().deniesDrops(blocks);
    }

    public static ToolRule deniesDrops(Tag<BlockType> blockTypeTag) {
        return ToolRule.factory().deniesDrops(blockTypeTag);
    }

    public static ToolRule overrideSpeed(List<BlockType> blocks, double speed) {
        return ToolRule.factory().overrideSpeed(blocks, speed);
    }

    public static ToolRule overrideSpeed(Tag<BlockType> blockTypeTag, double speed) {
        return ToolRule.factory().overrideSpeed(blockTypeTag, speed);
    }

    public static ToolRule forBlocks(List<BlockType> blocks, @Nullable Double speed, @Nullable Boolean drops) {
        return ToolRule.factory().forBlocks(blocks, speed, drops);
    }

    public static ToolRule forTag(Tag<BlockType> blockTypeTag, @Nullable Double speed, @Nullable Boolean drops) {
        return ToolRule.factory().forTag(blockTypeTag, speed, drops);
    }

    public Set<BlockType> blocks();

    public Optional<Double> speed();

    public Optional<Boolean> drops();

    private static Factory factory() {
        return Sponge.game().factoryProvider().provide(Factory.class);
    }

    public static interface Factory {
        public ToolRule minesAndDrops(List<BlockType> var1, double var2);

        public ToolRule minesAndDrops(Tag<BlockType> var1, double var2);

        public ToolRule deniesDrops(List<BlockType> var1);

        public ToolRule deniesDrops(Tag<BlockType> var1);

        public ToolRule overrideSpeed(List<BlockType> var1, double var2);

        public ToolRule overrideSpeed(Tag<BlockType> var1, double var2);

        public ToolRule forBlocks(List<BlockType> var1, @Nullable Double var2, @Nullable Boolean var3);

        public ToolRule forTag(Tag<BlockType> var1, @Nullable Double var2, @Nullable Boolean var3);
    }
}

