/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import org.spongepowered.api.data.type.StringRepresentable;
import org.spongepowered.api.util.AxisDirection;
import org.spongepowered.api.util.Cycleable;
import org.spongepowered.math.vector.Vector3d;

public enum Axis implements Cycleable<Axis>,
StringRepresentable
{
    X(new Vector3d(1.0f, 0.0f, 0.0f)),
    Y(new Vector3d(0.0f, 1.0f, 0.0f)),
    Z(new Vector3d(0.0f, 0.0f, 1.0f));

    private final Vector3d direction;

    private Axis(Vector3d vector3d) {
        this.direction = vector3d;
    }

    public static Axis closest(Vector3d vector) {
        double x = Math.abs(vector.x());
        double y = Math.abs(vector.y());
        double z = Math.abs(vector.z());
        if (x < y) {
            if (z < y) {
                return Y;
            }
            return Z;
        }
        if (x < z) {
            return Z;
        }
        return X;
    }

    public boolean isVectorAlongAxis(Vector3d vector) {
        return vector.abs().normalize().sub(this.direction).lengthSquared() == 0.0;
    }

    public double component(Vector3d vector3d) {
        switch (this.ordinal()) {
            case 0: {
                return this.direction.x();
            }
            case 1: {
                return this.direction.y();
            }
            case 2: {
                return this.direction.z();
            }
        }
        throw new IllegalStateException("Not capable of handling the " + this.name() + " axis!");
    }

    public AxisDirection direction(Vector3d vector3d) {
        double component = this.component(vector3d);
        if (component > 0.0) {
            return AxisDirection.PLUS;
        }
        if (component == 0.0) {
            return AxisDirection.ZERO;
        }
        return AxisDirection.MINUS;
    }

    public Vector3d toVector3d() {
        return this.direction;
    }

    public Vector3d toVector3dWithDirection(AxisDirection axisDirection) {
        return this.direction.mul((float)axisDirection.signum());
    }

    @Override
    public Axis cycleNext() {
        if (this == X) {
            return Y;
        }
        if (this == Y) {
            return Z;
        }
        return X;
    }

    @Override
    public String serializationString() {
        return this.name();
    }
}

