/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.chunk;

import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.volume.block.PhysicsAwareMutableBlockVolume;
import org.spongepowered.api.world.volume.entity.EntityVolume;
import org.spongepowered.math.vector.Vector3i;

public interface WorldChunk
extends Chunk<WorldChunk>,
EntityVolume.Modifiable<WorldChunk>,
PhysicsAwareMutableBlockVolume<WorldChunk>,
DataHolder.Mutable {
    public World<?, ?> world();

    default public Optional<WorldChunk> neighbor(Direction direction) {
        return this.neighbor(direction, false);
    }

    default public Optional<WorldChunk> neighbor(Direction direction, boolean shouldLoad) {
        Optional<Vector3i> neighborPosition = Sponge.server().chunkLayout().moveToChunk(this.chunkPosition(), direction);
        return neighborPosition.flatMap(vector3i -> this.world().loadChunk((Vector3i)vector3i, shouldLoad));
    }

    public double regionalDifficultyFactor();

    public double regionalDifficultyPercentage();
}

