/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.game;

import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.game.LocationBaseDataHolder;
import org.spongepowered.math.vector.Vector3i;

public interface TrackedVolume
extends BlockVolume,
LocationBaseDataHolder.Mutable {
    default public Optional<UUID> creator(Vector3i pos) {
        return this.creator(pos.x(), pos.y(), pos.z());
    }

    default public Optional<UUID> creator(int x, int y, int z) {
        return this.get(x, y, z, Keys.CREATOR);
    }

    default public Optional<UUID> notifier(Vector3i pos) {
        return this.notifier(pos.x(), pos.y(), pos.z());
    }

    default public Optional<UUID> notifier(int x, int y, int z) {
        return this.get(x, y, z, Keys.NOTIFIER);
    }

    default public void setCreator(Vector3i pos, @Nullable UUID uuid) {
        this.setCreator(pos.x(), pos.y(), pos.z(), uuid);
    }

    default public void setCreator(int x, int y, int z, @Nullable UUID uuid) {
        if (uuid == null) {
            this.remove(x, y, z, Keys.CREATOR);
        } else {
            this.offer(x, y, z, Keys.CREATOR, uuid);
        }
    }

    default public void setNotifier(Vector3i pos, @Nullable UUID uuid) {
        this.setNotifier(pos.x(), pos.y(), pos.z(), uuid);
    }

    default public void setNotifier(int x, int y, int z, @Nullable UUID uuid) {
        if (uuid == null) {
            this.remove(x, y, z, Keys.NOTIFIER);
        } else {
            this.offer(x, y, z, Keys.NOTIFIER, uuid);
        }
    }
}

