/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.spongepowered.api.Client;
import org.spongepowered.api.Game;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Server;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.network.channel.ChannelManager;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.registry.BuilderProvider;
import org.spongepowered.api.registry.FactoryProvider;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.util.metric.MetricsConfigManager;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.config.PluginConfigManager;
import org.spongepowered.common.registry.RegistryHolderLogic;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.scheduler.AsyncScheduler;
import org.spongepowered.common.server.ServerConsoleSystemSubject;
import org.spongepowered.common.util.LocaleCache;
import org.spongepowered.common.util.Preconditions;

@Singleton
public final class SpongeGame
implements Game,
SpongeRegistryHolder {
    private final Platform platform;
    private final BuilderProvider builderProvider;
    private final FactoryProvider factoryProvider;
    private final DataManager dataManager;
    private final PluginManager pluginManager;
    private final EventManager eventManager;
    private final PluginConfigManager configManager;
    private final ChannelManager channelManager;
    private final MetricsConfigManager metricsConfigManager;
    private final ServiceProvider.GameScoped serviceProvider;
    private final AsyncScheduler asyncScheduler;
    private RegistryHolderLogic registryHolder;
    private Client client;
    private Server server;
    private ServerConsoleSystemSubject systemSubject;

    @Inject
    public SpongeGame(Platform platform, BuilderProvider builderProvider, FactoryProvider factoryProvider, DataManager dataManager, PluginManager pluginManager, EventManager eventManager, PluginConfigManager configManager, ChannelManager channelManager, MetricsConfigManager metricsConfigManager, ServiceProvider.GameScoped serviceProvider) {
        this.platform = platform;
        this.builderProvider = builderProvider;
        this.factoryProvider = factoryProvider;
        this.dataManager = dataManager;
        this.pluginManager = pluginManager;
        this.eventManager = eventManager;
        this.configManager = configManager;
        this.channelManager = channelManager;
        this.metricsConfigManager = metricsConfigManager;
        this.serviceProvider = serviceProvider;
        this.asyncScheduler = new AsyncScheduler();
    }

    @Override
    public Path gameDirectory() {
        return SpongeCommon.gameDirectory();
    }

    @Override
    public ServerConsoleSystemSubject systemSubject() {
        if (this.systemSubject == null) {
            this.systemSubject = new ServerConsoleSystemSubject();
        }
        return this.systemSubject;
    }

    @Override
    public Platform platform() {
        return this.platform;
    }

    @Override
    public BuilderProvider builderProvider() {
        return this.builderProvider;
    }

    @Override
    public FactoryProvider factoryProvider() {
        return this.factoryProvider;
    }

    @Override
    public DataManager dataManager() {
        return this.dataManager;
    }

    @Override
    public PluginManager pluginManager() {
        return this.pluginManager;
    }

    @Override
    public EventManager eventManager() {
        return this.eventManager;
    }

    @Override
    public PluginConfigManager configManager() {
        return this.configManager;
    }

    @Override
    public ChannelManager channelManager() {
        return this.channelManager;
    }

    @Override
    public MetricsConfigManager metricsConfigManager() {
        return this.metricsConfigManager;
    }

    @Override
    public ServiceProvider.GameScoped serviceProvider() {
        return this.serviceProvider;
    }

    @Override
    public AsyncScheduler asyncScheduler() {
        return this.asyncScheduler;
    }

    @Override
    public Locale locale(String locale) {
        return LocaleCache.getLocale(Objects.requireNonNull(locale));
    }

    @Override
    public boolean isServerAvailable() {
        if (this.client != null) {
            return this.client.server().isPresent();
        }
        return this.server != null;
    }

    @Override
    public Server server() {
        if (this.client != null) {
            return this.client.server().orElseThrow(() -> new IllegalStateException("The singleplayer server is not available!"));
        }
        Preconditions.checkState(this.server != null, "The dedicated server is not available!");
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public boolean isClientAvailable() {
        return this.client != null;
    }

    @Override
    public Client client() {
        Preconditions.checkState(this.client != null, "The client is not available!");
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    @Override
    public RegistryHolderLogic registryHolder() {
        if (this.registryHolder == null) {
            this.registryHolder = new RegistryHolderLogic();
        }
        return this.registryHolder;
    }

    public String toString() {
        return new StringJoiner(", ", SpongeGame.class.getSimpleName() + "[", "]").add("platform=" + String.valueOf(this.platform)).toString();
    }
}

