/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.server.PlayerAdvancements;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTrigger;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTriggerConfiguration;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.advancement.SpongeFilteredTrigger;
import org.spongepowered.common.bridge.advancements.CriterionTriggerBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;

public class SpongeCriterionTrigger
implements CriterionTrigger<SpongeFilteredTrigger>,
CriterionTriggerBridge {
    private final Type triggerConfigurationType;
    final Function<JsonObject, FilteredTriggerConfiguration> constructor;
    private final Multimap<PlayerAdvancements, CriterionTrigger.Listener> listeners = HashMultimap.create();
    final @Nullable Consumer<CriterionEvent.Trigger> eventHandler;
    private final String name;

    public Codec<SpongeFilteredTrigger> codec() {
        return Codec.PASSTHROUGH.comapFlatMap(in -> {
            JsonObject json = ((JsonElement)in.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
            FilteredTriggerConfiguration config = this.constructor.apply(json);
            return DataResult.success((Object)new SpongeFilteredTrigger(config));
        }, trigger -> new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)trigger.serializeToJson()));
    }

    SpongeCriterionTrigger(Type triggerConfigurationType, Function<JsonObject, FilteredTriggerConfiguration> constructor, @Nullable Consumer<CriterionEvent.Trigger> eventHandler, String name) {
        this.triggerConfigurationType = triggerConfigurationType;
        this.eventHandler = eventHandler;
        this.constructor = constructor;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addPlayerListener(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener listener) {
        this.listeners.put((Object)playerAdvancementsIn, (Object)listener);
    }

    public void removePlayerListener(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener listener) {
        this.listeners.remove((Object)playerAdvancementsIn, (Object)listener);
    }

    public void removePlayerListeners(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.removeAll((Object)playerAdvancementsIn);
    }

    @Override
    public void bridge$trigger(ServerPlayer player) {
        PlayerAdvancements playerAdvancements = ((net.minecraft.server.level.ServerPlayer)player).getAdvancements();
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        TypeToken<?> typeToken = TypeToken.get(this.triggerConfigurationType);
        for (CriterionTrigger.Listener listener : new ArrayList(this.listeners.get((Object)playerAdvancements))) {
            net.minecraft.advancements.Advancement advancement = listener.advancement().value();
            ResourceKey advancementKey = (ResourceKey)listener.advancement().id();
            AdvancementCriterion advancementCriterion = (AdvancementCriterion)advancement.criteria().get(listener.criterion());
            CriterionEvent.Trigger<?> event = SpongeEventFactory.createCriterionEventTrigger(cause, (Advancement)advancement, advancementKey, advancementCriterion, typeToken, player, (FilteredTrigger)listener.trigger(), advancementCriterion.type().get(), this.eventHandler == null);
            if (this.eventHandler != null) {
                this.eventHandler.accept(event);
                if (!event.result()) continue;
            }
            SpongeCommon.post(event);
            if (!event.result()) continue;
            listener.run(playerAdvancements);
        }
    }

    public @Nullable Consumer<CriterionEvent.Trigger> getEventHandler() {
        return this.eventHandler;
    }
}

