/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.adventure.AdventureTextComponent;

public abstract class NativeComponentRenderer<C> {
    static final NativeComponentRenderer<Locale> INSTANCE = new NativeComponentRenderer<Locale>(){

        @Override
        public MessageFormat translate(@NonNull String key, @NonNull Locale locale) {
            return GlobalTranslator.translator().translate(key, locale);
        }
    };

    public static @NonNull Component apply(Component input, Locale locale) {
        if (input instanceof AdventureTextComponent) {
            return ((AdventureTextComponent)input).rendered(locale);
        }
        return NativeComponentRenderer.get().render(input.copy(), locale);
    }

    public static @NonNull NativeComponentRenderer<Locale> get() {
        return INSTANCE;
    }

    protected abstract @Nullable MessageFormat translate(@NonNull String var1, @NonNull C var2);

    public Component render(@NonNull MutableComponent component, @NonNull C context) {
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            component = this.renderTranslatable(component, contents, context);
        } else {
            this.renderSiblings((Component)component, context);
        }
        HoverEvent hover = component.getStyle().getHoverEvent();
        if (hover != null) {
            component.setStyle(component.getStyle().withHoverEvent(this.renderHoverEvent(hover, context)));
        }
        return component;
    }

    private HoverEvent renderHoverEvent(HoverEvent input, @NonNull C context) {
        HoverEvent.Action action = input.getAction();
        if (action == HoverEvent.Action.SHOW_TEXT) {
            Component original = (Component)input.getValue(HoverEvent.Action.SHOW_TEXT);
            return new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)this.render(original.copy(), context));
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.EntityTooltipInfo data = (HoverEvent.EntityTooltipInfo)input.getValue(HoverEvent.Action.SHOW_ENTITY);
            if (data.name.isPresent()) {
                Component rendered = this.render(((Component)data.name.get()).copy(), context);
                return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, (Object)new HoverEvent.EntityTooltipInfo(data.type, data.id, rendered));
            }
        }
        return input;
    }

    protected @NonNull MutableComponent renderTranslatable(MutableComponent component, @NonNull TranslatableContents contents, @NonNull C context) {
        MutableComponent result;
        MessageFormat format = this.translate(contents.getKey(), context);
        if (format == null) {
            Object[] args = contents.getArgs();
            if (args.length > 0) {
                int size = args.length;
                for (int i = 0; i < size; ++i) {
                    if (!(args[i] instanceof Component)) continue;
                    args[i] = this.render(((Component)args[i]).copy(), context);
                }
            }
            this.renderSiblings((Component)component, context);
            return component;
        }
        Object[] args = contents.getArgs();
        if (args.length == 0) {
            result = Component.literal((String)format.format(null, new StringBuffer(), null).toString());
        } else {
            result = Component.literal((String)"");
            Object[] nulls = new Object[args.length];
            StringBuffer sb = format.format(nulls, new StringBuffer(), (FieldPosition)null);
            AttributedCharacterIterator it = format.formatToCharacterIterator(nulls);
            while (it.getIndex() < it.getEndIndex()) {
                int end = it.getRunLimit();
                Integer index = (Integer)it.getAttribute(MessageFormat.Field.ARGUMENT);
                if (index != null && args[index] instanceof Component) {
                    result.append(this.render(((Component)args[index]).copy(), context));
                } else {
                    result.append((Component)Component.literal((String)sb.substring(it.getIndex(), end)));
                }
                it.setIndex(end);
            }
        }
        result.setStyle(component.getStyle());
        this.renderSiblings((Component)component, context, (idx, rendered) -> result.append(rendered));
        return result;
    }

    private void renderSiblings(Component component, C context) {
        this.renderSiblings(component, context, component.getSiblings()::set);
    }

    private void renderSiblings(Component component, C context, SiblingConsumer consumer) {
        List siblings = component.getSiblings();
        for (int i = 0; i < siblings.size(); ++i) {
            Component original = (Component)siblings.get(i);
            Component rendered = this.render(original.copy(), context);
            consumer.accept(i, rendered);
        }
    }

    @FunctionalInterface
    static interface SiblingConsumer {
        public void accept(int var1, Component var2);
    }
}

