/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.collect.Lists;
import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.util.Preconditions;

public final class NBTTranslator
implements DataTranslator<CompoundTag> {
    public static final NBTTranslator INSTANCE = new NBTTranslator();
    private static final TypeToken<CompoundTag> TOKEN = TypeToken.get(CompoundTag.class);
    public static final String BOOLEAN_IDENTIFIER = "$Boolean";

    private static CompoundTag containerToCompound(DataView container) {
        Objects.requireNonNull(container);
        CompoundTag compound = new CompoundTag();
        NBTTranslator.containerToCompound(container, compound);
        return compound;
    }

    private static void containerToCompound(DataView container, CompoundTag compound) {
        Objects.requireNonNull(container);
        Objects.requireNonNull(compound);
        for (Map.Entry<DataQuery, Object> entry : container.values(false).entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey().asString('.');
            if (value instanceof DataView) {
                CompoundTag inner = new CompoundTag();
                NBTTranslator.containerToCompound(container.getView(entry.getKey()).get(), inner);
                compound.put(key, (Tag)inner);
                continue;
            }
            if (value instanceof Boolean) {
                compound.put(key + BOOLEAN_IDENTIFIER, (Tag)ByteTag.valueOf((boolean)((Boolean)value)));
                continue;
            }
            compound.put(key, NBTTranslator.getBaseFromObject(value));
        }
    }

    private static Tag getBaseFromObject(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof Boolean) {
            return ByteTag.valueOf((boolean)((Boolean)value));
        }
        if (value instanceof Byte) {
            return ByteTag.valueOf((byte)((Byte)value));
        }
        if (value instanceof Short) {
            return ShortTag.valueOf((short)((Short)value));
        }
        if (value instanceof Integer) {
            return IntTag.valueOf((int)((Integer)value));
        }
        if (value instanceof Long) {
            return LongTag.valueOf((long)((Long)value));
        }
        if (value instanceof Float) {
            return FloatTag.valueOf((float)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DoubleTag.valueOf((double)((Double)value));
        }
        if (value instanceof String) {
            return StringTag.valueOf((String)((String)value));
        }
        if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                return new ByteArrayTag((byte[])value);
            }
            if (value instanceof Byte[]) {
                byte[] array = new byte[((Byte[])value).length];
                int counter = 0;
                for (Byte data : (Byte[])value) {
                    array[counter++] = data;
                }
                return new ByteArrayTag(array);
            }
            if (value instanceof int[]) {
                return new IntArrayTag((int[])value);
            }
            if (value instanceof Integer[]) {
                int[] array = new int[((Integer[])value).length];
                int counter = 0;
                for (Integer data : (Integer[])value) {
                    array[counter++] = data;
                }
                return new IntArrayTag(array);
            }
            if (value instanceof long[]) {
                return new LongArrayTag((long[])value);
            }
            if (value instanceof Long[]) {
                long[] array = new long[((Long[])value).length];
                int counter = 0;
                for (Long data : (Long[])value) {
                    array[counter++] = data;
                }
                return new LongArrayTag(array);
            }
        } else {
            if (value instanceof List) {
                ListTag list = new ListTag();
                for (Object object : (List)value) {
                    list.add((Object)NBTTranslator.getBaseFromObject(object));
                }
                return list;
            }
            if (value instanceof Map) {
                CompoundTag compound = new CompoundTag();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    if (entry.getKey() instanceof DataQuery) {
                        if (entry.getValue() instanceof Boolean) {
                            compound.putBoolean(((DataQuery)entry.getKey()).asString('.') + BOOLEAN_IDENTIFIER, ((Boolean)entry.getValue()).booleanValue());
                            continue;
                        }
                        compound.put(((DataQuery)entry.getKey()).asString('.'), NBTTranslator.getBaseFromObject(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey() instanceof String) {
                        compound.put((String)entry.getKey(), NBTTranslator.getBaseFromObject(entry.getValue()));
                        continue;
                    }
                    compound.put(entry.getKey().toString(), NBTTranslator.getBaseFromObject(entry.getValue()));
                }
                return compound;
            }
            if (value instanceof DataSerializable) {
                return NBTTranslator.containerToCompound(((DataSerializable)value).toContainer());
            }
            if (value instanceof DataView) {
                return NBTTranslator.containerToCompound((DataView)value);
            }
        }
        throw new IllegalArgumentException("Unable to translate object to NBTBase: " + String.valueOf(value));
    }

    private static DataContainer getViewFromCompound(CompoundTag compound) {
        Objects.requireNonNull(compound);
        DataContainer container = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
        INSTANCE.addTo(compound, (DataView)container);
        return container;
    }

    private static void setInternal(Tag base, byte type, DataView view, String key) {
        Objects.requireNonNull(base);
        Objects.requireNonNull(view);
        Objects.requireNonNull(key);
        Preconditions.checkArgument(!key.isEmpty());
        Preconditions.checkArgument(type > 0 && type <= 12);
        switch (type) {
            case 1: {
                if (key.contains(BOOLEAN_IDENTIFIER)) {
                    view.set(DataQuery.of(key.replace(BOOLEAN_IDENTIFIER, "")), ((ByteTag)base).getAsByte() != 0);
                    break;
                }
                view.set(DataQuery.of(key), ((ByteTag)base).getAsByte());
                break;
            }
            case 2: {
                view.set(DataQuery.of(key), ((ShortTag)base).getAsShort());
                break;
            }
            case 3: {
                view.set(DataQuery.of(key), ((IntTag)base).getAsInt());
                break;
            }
            case 4: {
                view.set(DataQuery.of(key), ((LongTag)base).getAsLong());
                break;
            }
            case 5: {
                view.set(DataQuery.of(key), Float.valueOf(((FloatTag)base).getAsFloat()));
                break;
            }
            case 6: {
                view.set(DataQuery.of(key), ((DoubleTag)base).getAsDouble());
                break;
            }
            case 7: {
                view.set(DataQuery.of(key), ((ByteArrayTag)base).getAsByteArray());
                break;
            }
            case 8: {
                view.set(DataQuery.of(key), base.getAsString());
                break;
            }
            case 9: {
                ListTag list = (ListTag)base;
                byte listType = list.getElementType();
                int count = list.size();
                ArrayList objectList = Lists.newArrayListWithCapacity((int)count);
                for (Tag inbt : list) {
                    objectList.add(NBTTranslator.fromTagBase(inbt, listType));
                }
                view.set(DataQuery.of(key), objectList);
                break;
            }
            case 10: {
                DataView internalView = view.createView(DataQuery.of(key));
                CompoundTag compound = (CompoundTag)base;
                for (String internalKey : compound.getAllKeys()) {
                    Tag internalBase = compound.get(internalKey);
                    byte internalType = internalBase.getId();
                    NBTTranslator.setInternal(internalBase, internalType, internalView, internalKey);
                }
                break;
            }
            case 11: {
                view.set(DataQuery.of(key), ((IntArrayTag)base).getAsIntArray());
                break;
            }
            case 12: {
                view.set(DataQuery.of(key), ((LongArrayTag)base).getAsLongArray());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown NBT type " + type);
            }
        }
    }

    private static Object fromTagBase(Tag base, byte type) {
        switch (type) {
            case 1: {
                return ((ByteTag)base).getAsByte();
            }
            case 2: {
                return ((ShortTag)base).getAsShort();
            }
            case 3: {
                return ((IntTag)base).getAsInt();
            }
            case 4: {
                return ((LongTag)base).getAsLong();
            }
            case 5: {
                return Float.valueOf(((FloatTag)base).getAsFloat());
            }
            case 6: {
                return ((DoubleTag)base).getAsDouble();
            }
            case 7: {
                return ((ByteArrayTag)base).getAsByteArray();
            }
            case 8: {
                return base.getAsString();
            }
            case 9: {
                ListTag list = (ListTag)base;
                byte listType = list.getElementType();
                int count = list.size();
                ArrayList objectList = Lists.newArrayListWithCapacity((int)count);
                for (Tag inbt : list) {
                    objectList.add(NBTTranslator.fromTagBase(inbt, listType));
                }
                return objectList;
            }
            case 10: {
                return NBTTranslator.getViewFromCompound((CompoundTag)base);
            }
            case 11: {
                return ((IntArrayTag)base).getAsIntArray();
            }
            case 12: {
                return ((LongArrayTag)base).getAsLongArray();
            }
        }
        return null;
    }

    public void translateContainerToData(CompoundTag node, DataView container) {
        NBTTranslator.containerToCompound(container, node);
    }

    public DataContainer translateFrom(CompoundTag node) {
        return NBTTranslator.getViewFromCompound(node);
    }

    @Override
    public TypeToken<CompoundTag> token() {
        return TOKEN;
    }

    @Override
    public CompoundTag translate(DataView view) throws InvalidDataException {
        return NBTTranslator.containerToCompound(view);
    }

    @Override
    public DataContainer translate(CompoundTag obj) throws InvalidDataException {
        return NBTTranslator.getViewFromCompound(obj);
    }

    @Override
    public DataView addTo(CompoundTag compound, DataView container) {
        for (String key : compound.getAllKeys()) {
            Tag base = compound.get(key);
            byte type = base.getId();
            NBTTranslator.setInternal(base, type, container, key);
        }
        return container;
    }
}

