/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence.datastore;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.common.data.persistence.datastore.SpongeDataStore;
import org.spongepowered.common.data.persistence.datastore.VanillaDataStore;

public final class DataStoreRegistry {
    private final DataStore NO_OP_DATASTORE = new VanillaDataStore(Collections.emptyMap(), Collections.emptyList());
    private final Multimap<Key<?>, DataStore> dataStoreByValueKey = HashMultimap.create();
    private final Multimap<ResourceKey, DataStore> dataStoreByDataStoreKey = HashMultimap.create();
    private final List<DataStore> allDataStores = new ArrayList<DataStore>();
    private final Map<LookupKey, DataStore> dataStoreCache = new ConcurrentHashMap<LookupKey, DataStore>();
    private final Multimap<Type, DataStore> dataStoreByTokenCache = HashMultimap.create();

    public void register(DataStore dataStore, Iterable<Key<?>> keys) {
        keys.forEach(k -> this.dataStoreByValueKey.put(k, (Object)dataStore));
        if (dataStore instanceof SpongeDataStore) {
            ResourceKey customDataKey = ((SpongeDataStore)dataStore).getDataStoreKey();
            this.dataStoreByDataStoreKey.put((Object)customDataKey, (Object)dataStore);
        }
        this.allDataStores.add(dataStore);
        this.dataStoreCache.clear();
        this.dataStoreByTokenCache.clear();
    }

    public Collection<DataStore> getDataStores(Key<?> dataKey) {
        return this.dataStoreByValueKey.get(dataKey);
    }

    public DataStore getDataStore(Key<?> dataKey, TypeToken<? extends DataHolder> holderType) {
        return this.getDataStore(dataKey, holderType.getType());
    }

    public DataStore getDataStore(Key<?> dataKey, Type holderType) {
        return this.dataStoreCache.computeIfAbsent(new LookupKey(holderType, dataKey), this::loadDataStore);
    }

    public Optional<DataStore> getDataStore(ResourceKey key, Type holderType) {
        List<DataStore> dataStores = this.filterDataStoreCandidates(this.dataStoreByDataStoreKey.get((Object)key), holderType);
        if (dataStores.size() > 1) {
            throw new IllegalStateException("Multiple data-stores registered for the same key (" + String.valueOf(key) + ") and data-holder " + holderType.toString());
        }
        return dataStores.stream().findAny();
    }

    private DataStore loadDataStore(LookupKey lookupKey) {
        List<DataStore> dataStores = this.filterDataStoreCandidates(this.dataStoreByValueKey.get(lookupKey.key), lookupKey.holderType);
        if (dataStores.size() > 1) {
            throw new IllegalStateException("Multiple data-stores registered for the same data-key (" + String.valueOf(lookupKey.key.key()) + ") and data-holder " + lookupKey.holderType.toString());
        }
        if (dataStores.isEmpty()) {
            dataStores.add(this.NO_OP_DATASTORE);
        }
        return dataStores.get(0);
    }

    private List<DataStore> filterDataStoreCandidates(Collection<DataStore> candidates, Type holderType) {
        return candidates.stream().filter(ds -> ds.supportedTypes().stream().anyMatch(token -> GenericTypeReflector.isSuperType(token, holderType))).collect(Collectors.toList());
    }

    public Collection<DataStore> getDataStoresForType(Class<? extends DataHolder> holderType) {
        if (!this.dataStoreByTokenCache.containsKey(holderType)) {
            for (DataStore dataStore : this.allDataStores) {
                if (!dataStore.supportedTypes().stream().anyMatch(token -> GenericTypeReflector.isSuperType(token, holderType))) continue;
                this.dataStoreByTokenCache.put(holderType, (Object)dataStore);
            }
        }
        return this.dataStoreByTokenCache.get(holderType);
    }

    private static class LookupKey {
        private final Type holderType;
        private final Key<?> key;

        public LookupKey(Type holderType, Key<?> key) {
            this.holderType = holderType;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupKey lookupKey = (LookupKey)o;
            return this.holderType.equals(lookupKey.holderType) && this.key.equals(lookupKey.key);
        }

        public int hashCode() {
            return Objects.hash(this.holderType, this.key);
        }
    }
}

