/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.data.provider.AbstractDataProvider;
import org.spongepowered.common.data.provider.MutableDataProvider;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.TypeTokenUtil;

public abstract class GenericMutableDataProviderBase<H, V extends Value<E>, E>
extends MutableDataProvider<V, E>
implements AbstractDataProvider.KnownHolderType {
    private final Class<H> holderType;

    protected GenericMutableDataProviderBase(Supplier<? extends Key<V>> key, Class<H> holderType) {
        this(key.get(), holderType);
    }

    protected GenericMutableDataProviderBase(Key<V> key, Class<H> holderType) {
        super(key);
        this.holderType = holderType;
    }

    protected GenericMutableDataProviderBase(Supplier<? extends Key<V>> key) {
        this(key.get());
    }

    protected GenericMutableDataProviderBase(Key<V> key) {
        super(key);
        this.holderType = GenericTypeReflector.erase(TypeTokenUtil.typeArgumentFromSupertype(this.getClass(), GenericMutableDataProviderBase.class, 0));
    }

    private boolean isTypeAllowed(DataHolder dataHolder) {
        return this.holderType.isInstance(dataHolder);
    }

    public Class<H> getHolderType() {
        return this.holderType;
    }

    protected boolean supports(H dataHolder) {
        return true;
    }

    protected abstract Optional<E> getFrom(H var1);

    public Optional<V> getValueFrom(H dataHolder) {
        return this.getFrom(dataHolder).map(e -> this.constructValue(dataHolder, e));
    }

    protected boolean set(H dataHolder, E value) {
        return false;
    }

    protected DataTransactionResult setAndGetResult(H dataHolder, E value) {
        Optional<Value.Immutable<E>> originalValue = this.getFrom(dataHolder).map(e -> this.constructValue(dataHolder, e).asImmutable());
        Value.Immutable<E> originalReplacementValue = Value.immutableOf(this.key(), value);
        return this.callReplacementEvent((DataHolder.Mutable)dataHolder, originalValue, originalReplacementValue).map(replacementValue -> {
            try {
                if (this.set(dataHolder, value)) {
                    DataTransactionResult.Builder builder = DataTransactionResult.builder();
                    originalValue.ifPresent(builder::replace);
                    return builder.result(DataTransactionResult.Type.SUCCESS).success((Value.Immutable<?>)replacementValue).build();
                }
                return DataTransactionResult.failResult(replacementValue);
            }
            catch (Exception e) {
                SpongeCommon.logger().debug("An exception occurred when setting data: ", (Throwable)e);
                return DataTransactionResult.errorResult(replacementValue);
            }
        }).orElse(DataTransactionResult.failResult(originalReplacementValue));
    }

    protected V constructValue(H dataHolder, E element) {
        return Value.genericImmutableOf(this.key(), element);
    }

    protected boolean delete(H dataHolder) {
        return false;
    }

    protected DataTransactionResult deleteAndGetResult(H dataHolder) {
        Optional<Value.Immutable> originalValue = this.getFrom(dataHolder).map(e -> this.constructValue(dataHolder, e).asImmutable());
        if (!originalValue.isPresent()) {
            return DataTransactionResult.failNoData();
        }
        if (this.delete(dataHolder)) {
            return DataTransactionResult.successRemove(originalValue.get());
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public final boolean isSupported(DataHolder dataHolder) {
        return this.isTypeAllowed(dataHolder) && this.supports(dataHolder);
    }

    @Override
    public boolean isSupported(Type dataHolder) {
        return this.holderType.isAssignableFrom(GenericTypeReflector.erase(dataHolder));
    }

    @Override
    public final Optional<V> value(DataHolder dataHolder) {
        if (!this.isSupported(dataHolder)) {
            return Optional.empty();
        }
        return this.getValueFrom(dataHolder);
    }

    @Override
    public final Optional<E> get(DataHolder dataHolder) {
        if (!this.isSupported(dataHolder)) {
            return Optional.empty();
        }
        return this.getFrom(dataHolder);
    }

    @Override
    public final DataTransactionResult offerValue(DataHolder.Mutable dataHolder, V value) {
        if (!this.isSupported(dataHolder)) {
            return DataTransactionResult.failNoData();
        }
        Optional<Value.Immutable<E>> originalValue = this.getFrom(dataHolder).map(e -> this.constructValue(dataHolder, e).asImmutable());
        Value.Immutable originalReplacementValue = value.asImmutable();
        return this.callReplacementEvent(dataHolder, originalValue, originalReplacementValue).map(replacementValue -> {
            try {
                if (this.set(dataHolder, value.get())) {
                    DataTransactionResult.Builder builder = DataTransactionResult.builder();
                    originalValue.ifPresent(builder::replace);
                    return builder.result(DataTransactionResult.Type.SUCCESS).success((Value.Immutable<?>)replacementValue).build();
                }
                return DataTransactionResult.failResult(replacementValue);
            }
            catch (Exception e) {
                SpongeCommon.logger().debug("An exception occurred when setting data: ", (Throwable)e);
                return DataTransactionResult.errorResult(replacementValue);
            }
        }).orElse(DataTransactionResult.failResult(originalReplacementValue));
    }

    @Override
    public final DataTransactionResult offer(DataHolder.Mutable dataHolder, E element) {
        if (!this.isSupported(dataHolder)) {
            return DataTransactionResult.failResult(Value.immutableOf(this.key(), element));
        }
        return this.setAndGetResult(dataHolder, element);
    }

    @Override
    public final DataTransactionResult remove(DataHolder.Mutable dataHolder) {
        if (!this.isSupported(dataHolder)) {
            return DataTransactionResult.failNoData();
        }
        return this.deleteAndGetResult(dataHolder);
    }

    private Optional<Value.Immutable<E>> callReplacementEvent(DataHolder.Mutable dataHolder, Optional<Value.Immutable<E>> originalValue, Value.Immutable<E> replacementValue) {
        Entity entity;
        if (!(dataHolder instanceof Entity) || ((EntityAccessor)((Object)(entity = (Entity)dataHolder))).accessor$levelCallback() == EntityInLevelCallback.NULL || ((SpongeDataHolderBridge)((Object)dataHolder)).brigde$isDeserializing()) {
            return Optional.of(replacementValue);
        }
        DataTransactionResult.Builder transaction = DataTransactionResult.builder().success(replacementValue).result(DataTransactionResult.Type.SUCCESS);
        originalValue.ifPresent(transaction::replace);
        ChangeDataHolderEvent.ValueChange valueChange = SpongeEventFactory.createChangeDataHolderEventValueChange(PhaseTracker.SERVER.currentCause(), transaction.build(), dataHolder);
        if (SpongeCommon.post(valueChange)) {
            return Optional.empty();
        }
        return valueChange.endResult().successfulValue(replacementValue.key());
    }
}

