/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.block.entity;

import java.util.List;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.common.bridge.world.level.block.entity.BannerBlockEntityBridge;
import org.spongepowered.common.data.provider.DataProviderRegistrator;

public final class BannerData {
    private BannerData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(BannerBlockEntity.class).create(Keys.BANNER_PATTERN_LAYERS).get(h -> h.getPatterns().layers().stream().map(BannerPatternLayer.class::cast).toList())).setAnd((h, v) -> {
            Level world = h.getLevel();
            if (world != null && !world.isClientSide) {
                BannerData.applyBannerPatternLayers(h, v);
                return true;
            }
            return false;
        })).create(Keys.DYE_COLOR).get(h -> ((BannerBlockEntityBridge)h).bridge$getBaseColor())).setAnd((h, v) -> {
            Level world = h.getLevel();
            if (world != null && !world.isClientSide) {
                ((BannerBlockEntityBridge)h).bridge$setBaseColor((DyeColor)v);
                return true;
            }
            return false;
        });
    }

    private static void applyBannerPatternLayers(BannerBlockEntity h, List<BannerPatternLayer> v) {
        DataComponentMap.Builder builder = DataComponentMap.builder();
        builder.addAll(h.collectComponents());
        builder.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers(v.stream().map(BannerPatternLayers.Layer.class::cast).toList()));
        DataComponentMap components = builder.build();
        h.applyComponents(components, DataComponentPatch.EMPTY);
    }
}

