/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.accessor.world.item.AdventureModePredicateAccessor;
import org.spongepowered.common.data.provider.DataProviderRegistrator;

public final class BlockTypeItemStackData {
    private BlockTypeItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.BREAKABLE_BLOCK_TYPES).get(h -> BlockTypeItemStackData.get(h, (DataComponentType<AdventureModePredicate>)DataComponents.CAN_BREAK))).set((h, v) -> BlockTypeItemStackData.set(h, (DataComponentType<AdventureModePredicate>)DataComponents.CAN_BREAK, v))).create(Keys.PLACEABLE_BLOCK_TYPES).get(h -> BlockTypeItemStackData.get(h, (DataComponentType<AdventureModePredicate>)DataComponents.CAN_PLACE_ON))).set((h, v) -> BlockTypeItemStackData.set(h, (DataComponentType<AdventureModePredicate>)DataComponents.CAN_PLACE_ON, v));
    }

    private static Set<BlockType> get(ItemStack stack, DataComponentType<AdventureModePredicate> component) {
        AdventureModePredicate predicate = (AdventureModePredicate)stack.get(component);
        if (predicate != null) {
            return ((AdventureModePredicateAccessor)predicate).accessor$predicates().stream().flatMap(p -> ((HolderSet)p.blocks().orElse(HolderSet.direct((Holder[])new Holder[0]))).stream()).map(Holder::value).map(BlockType.class::cast).collect(Collectors.toSet());
        }
        return null;
    }

    private static boolean set(ItemStack stack, DataComponentType<AdventureModePredicate> component, Set<? extends BlockType> value) {
        if (value.isEmpty()) {
            stack.remove(component);
            return true;
        }
        AdventureModePredicate prev = (AdventureModePredicate)stack.get(component);
        BlockPredicate blockPredicate = BlockPredicate.Builder.block().of(value.stream().map(Block.class::cast).toList()).build();
        AdventureModePredicate predicate = new AdventureModePredicate(List.of(blockPredicate), prev == null || prev.showInTooltip());
        stack.set(component, (Object)predicate);
        return true;
    }
}

