/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.LodestoneTracker;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.VecHelper;

final class CompassItemData {
    private CompassItemData() {
    }

    static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.LODESTONE).get(stack -> {
            LodestoneTracker component = (LodestoneTracker)stack.get(DataComponents.LODESTONE_TRACKER);
            if (component == null) {
                return null;
            }
            GlobalPos globalPos = (GlobalPos)component.target().get();
            return ServerLocation.of((ServerWorld)SpongeCommon.server().getLevel(globalPos.dimension()), VecHelper.toVector3d(globalPos.pos()));
        })).set((stack, location) -> {
            ResourceKey dim = ((ServerLevel)location.world()).dimension();
            stack.set(DataComponents.LODESTONE_TRACKER, (Object)new LodestoneTracker(Optional.of(new GlobalPos(dim, VecHelper.toBlockPos(location))), true));
        })).create(Keys.LODESTONE_TRACKED).delete(stack -> stack.remove(DataComponents.LODESTONE_TRACKER))).get(stack -> {
            LodestoneTracker tracker = (LodestoneTracker)stack.get(DataComponents.LODESTONE_TRACKER);
            return tracker != null && tracker.tracked();
        })).set((stack, isTracked) -> {
            Optional oldTarget = Optional.ofNullable((LodestoneTracker)stack.get(DataComponents.LODESTONE_TRACKER)).flatMap(LodestoneTracker::target);
            stack.set(DataComponents.LODESTONE_TRACKER, (Object)new LodestoneTracker(oldTarget, isTracked.booleanValue()));
        })).delete(stack -> {
            Optional oldTarget = Optional.ofNullable((LodestoneTracker)stack.get(DataComponents.LODESTONE_TRACKER)).flatMap(LodestoneTracker::target);
            if (oldTarget.isPresent()) {
                stack.set(DataComponents.LODESTONE_TRACKER, (Object)new LodestoneTracker(oldTarget, false));
            } else {
                stack.remove(DataComponents.LODESTONE_TRACKER);
            }
        });
    }
}

