/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.core.RegistryAccess;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.datapack.DataPackEntry;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.datapack.DataPackDecoder;
import org.spongepowered.common.datapack.DataPackEncoder;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.datapack.SpongeDataPack;

public class JsonDataPackSerializer<T extends DataPackEntry<T>>
extends DataPackSerializer<JsonElement, T> {
    public JsonDataPackSerializer(DataPackEncoder<JsonElement, T> encoder, DataPackDecoder<JsonElement, T> decoder) {
        super(encoder, decoder);
    }

    @Override
    public String fileEnding() {
        return ".json";
    }

    @Override
    public void serializeObject(SpongeDataPack<JsonElement, T> pack, Path packDir, T packEntry) throws IOException {
        JsonElement serialized = (JsonElement)this.encoder.encode(packEntry, (RegistryAccess)SpongeCommon.server().registryAccess());
        Path file = this.packEntryFile(pack.type(), packEntry.key(), packDir);
        JsonElement finalJson = this.transformSerialized(file, packEntry, serialized);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        JsonDataPackSerializer.writeFile(file, finalJson);
    }

    protected JsonElement transformSerialized(Path file, T entry, JsonElement serialized) throws IOException {
        return serialized;
    }

    @Override
    protected void serializeAdditional(SpongeDataPack<JsonElement, T> type, Path packDir, T entry) throws IOException {
    }

    @Override
    public T deserialize(SpongeDataPack<JsonElement, T> pack, Path file, ResourceKey key) throws IOException {
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            T t = this.deserialize(pack, stream, key);
            return t;
        }
    }

    @Override
    public T deserialize(SpongeDataPack<JsonElement, T> pack, InputStream is, ResourceKey key) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is);){
            JsonElement element = JsonParser.parseReader(reader);
            if (this.decoder != null) {
                Object t = this.decoder.decode(pack, key, element, (RegistryAccess)SpongeCommon.server().registryAccess());
                return t;
            }
        }
        return null;
    }

    public static void writeFile(Path file, JsonElement object) throws IOException {
        Files.deleteIfExists(file);
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(file, new OpenOption[0]);){
            bufferedwriter.write(object.toString());
        }
    }
}

