/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.common.effect.particle.CachedParticlePacket;
import org.spongepowered.common.util.Constants;

public final class SpongeParticleEffect
implements ParticleEffect {
    @Nullable CachedParticlePacket cachedPacket;
    private final ParticleType type;
    private final Map<ParticleOption<?>, Object> options;

    public SpongeParticleEffect(ParticleType type, Map<ParticleOption<?>, Object> options) {
        this.options = ImmutableMap.copyOf(options);
        this.type = type;
    }

    @Override
    public ParticleType type() {
        return this.type;
    }

    @Override
    public <V> Optional<V> option(ParticleOption<V> option) {
        return Optional.ofNullable(this.options.get(option));
    }

    @Override
    public Map<ParticleOption<?>, Object> options() {
        return this.options;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer dataContainer = DataContainer.createNew();
        dataContainer.set(Constants.Particles.PARTICLE_TYPE, this.type);
        dataContainer.set(Constants.Particles.PARTICLE_OPTIONS, this.options.entrySet().stream().map(entry -> DataContainer.createNew().set(Constants.Particles.PARTICLE_OPTION_KEY, entry.getKey()).set(Constants.Particles.PARTICLE_OPTION_VALUE, entry.getValue())).collect(Collectors.toList()));
        return dataContainer;
    }
}

