/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.effect.particle.CachedParticlePacket;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3f;

public final class SpongeParticleHelper {
    public static void sendPackets(ParticleEffect particleEffect, Vector3d position, int radius, ResourceKey<Level> type, PlayerList playerList) {
        List<Packet<?>> packets = SpongeParticleHelper.toPackets(particleEffect, position);
        if (!packets.isEmpty()) {
            double x = position.x();
            double y = position.y();
            double z = position.z();
            for (Packet<?> packet : packets) {
                playerList.broadcast(null, x, y, z, (double)radius, type, packet);
            }
        }
    }

    public static List<Packet<?>> toPackets(ParticleEffect effect, Vector3d position) {
        ArrayList packets = new ArrayList();
        SpongeParticleHelper.getCachedPacket((SpongeParticleEffect)effect).process(position, packets);
        return packets;
    }

    public static @Nullable ParticleOptions vanillaParticleOptions(ParticleEffect effect) {
        return SpongeParticleHelper.getCachedPacket((SpongeParticleEffect)effect).particleOptions();
    }

    private static CachedParticlePacket getCachedPacket(SpongeParticleEffect effect) {
        if (effect.cachedPacket == null) {
            org.spongepowered.api.effect.particle.ParticleType type = effect.type();
            effect.cachedPacket = SpongeParticleHelper.getNamedPacket(effect, (ParticleType)type);
        }
        return effect.cachedPacket;
    }

    private static CachedParticlePacket getNamedPacket(ParticleEffect effect, ParticleType<?> internalType) {
        Vector3f offset = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.OFFSET).get().toFloat();
        int quantity = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.QUANTITY).get();
        Vector3f velocity = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.VELOCITY).orElse(Vector3d.ZERO).toFloat();
        if (internalType instanceof SimpleParticleType) {
            return new NamedCachedPacket((ParticleOptions)internalType, offset, quantity, velocity);
        }
        if (internalType == ParticleTypes.BLOCK || internalType == ParticleTypes.BLOCK_MARKER || internalType == ParticleTypes.FALLING_DUST || internalType == ParticleTypes.DUST_PILLAR) {
            org.spongepowered.api.block.BlockState state = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.BLOCK_STATE).get();
            BlockParticleOption particleData = new BlockParticleOption(internalType, (BlockState)state);
            return new NamedCachedPacket((ParticleOptions)particleData, offset, quantity, velocity);
        }
        if (internalType == ParticleTypes.DUST_COLOR_TRANSITION) {
            Color color = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.COLOR).get();
            Color toColor = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.TO_COLOR).get();
            double scale = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.SCALE).get();
            DustColorTransitionOptions particleData = new DustColorTransitionOptions(new org.joml.Vector3f((float)color.red() / 255.0f, (float)color.green() / 255.0f, (float)color.blue() / 255.0f), new org.joml.Vector3f((float)toColor.red() / 255.0f, (float)toColor.green() / 255.0f, (float)toColor.blue() / 255.0f), (float)scale);
            return new NamedCachedPacket((ParticleOptions)particleData, offset, quantity, velocity);
        }
        if (internalType == ParticleTypes.DUST) {
            Color color = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.COLOR).get();
            double scale = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.SCALE).get();
            DustParticleOptions particleData = new DustParticleOptions(new org.joml.Vector3f((float)color.red() / 255.0f, (float)color.green() / 255.0f, (float)color.blue() / 255.0f), (float)scale);
            return new NamedCachedPacket((ParticleOptions)particleData, offset, quantity, velocity);
        }
        if (internalType == ParticleTypes.ITEM) {
            ItemStackSnapshot snapshot = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.ITEM_STACK_SNAPSHOT).get();
            ItemParticleOption particleData = new ItemParticleOption(internalType, (ItemStack)snapshot.createStack());
            return new NamedCachedPacket((ParticleOptions)particleData, offset, quantity, velocity);
        }
        if (internalType == ParticleTypes.SCULK_CHARGE) {
            double roll = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.ROLL).get();
            SculkChargeParticleOptions particleData = new SculkChargeParticleOptions((float)roll);
            return new NamedCachedPacket((ParticleOptions)particleData, offset, quantity, velocity);
        }
        if (internalType == ParticleTypes.SHRIEK) {
            int delay = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.DELAY).get();
            ShriekParticleOption particleData = new ShriekParticleOption(delay);
            return new NamedCachedPacket((ParticleOptions)particleData, offset, quantity, velocity);
        }
        if (internalType == ParticleTypes.VIBRATION) {
            Ticks delay = effect.optionOrDefault(org.spongepowered.api.effect.particle.ParticleOptions.TRAVEL_TIME).get();
            VibrationParticleOption particleData = new VibrationParticleOption((PositionSource)new BlockPositionSource(BlockPos.ZERO), (int)delay.ticks());
            return new NamedCachedPacket((ParticleOptions)particleData, offset, quantity, velocity);
        }
        return EmptyCachedPacket.INSTANCE;
    }

    public static int getDirectionId(Direction direction) {
        if (direction.isSecondaryOrdinal()) {
            direction = Direction.closest(direction.asOffset(), Direction.Division.ORDINAL);
        }
        switch (direction) {
            case SOUTHEAST: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case SOUTHWEST: {
                return 2;
            }
            case EAST: {
                return 3;
            }
            case WEST: {
                return 5;
            }
            case NORTHEAST: {
                return 6;
            }
            case NORTH: {
                return 7;
            }
            case NORTHWEST: {
                return 8;
            }
        }
        return 4;
    }

    public static int getBlockStateId(ParticleEffect effect, Optional<org.spongepowered.api.block.BlockState> defaultBlockState) {
        Optional<org.spongepowered.api.block.BlockState> blockState = effect.option(org.spongepowered.api.effect.particle.ParticleOptions.BLOCK_STATE);
        if (blockState.isPresent()) {
            return Block.getId((BlockState)((BlockState)blockState.get()));
        }
        Optional<ItemStackSnapshot> itemSnapshot = effect.option(org.spongepowered.api.effect.particle.ParticleOptions.ITEM_STACK_SNAPSHOT);
        if (itemSnapshot.isPresent()) {
            Optional<BlockType> blockType = itemSnapshot.get().type().block();
            return blockType.map(type -> Block.getId((BlockState)((BlockState)type.defaultState()))).orElse(0);
        }
        return defaultBlockState.map(state -> Block.getId((BlockState)((BlockState)state))).orElse(0);
    }

    public static ParticleEffect spongeParticleOptions(ParticleOptions effect) {
        ParticleType type = effect.getType();
        if (type instanceof SimpleParticleType) {
            return new SpongeParticleEffect((org.spongepowered.api.effect.particle.ParticleType)type, Collections.emptyMap());
        }
        if (effect instanceof BlockParticleOption) {
            BlockParticleOption blockOptions = (BlockParticleOption)effect;
            return new SpongeParticleEffect((org.spongepowered.api.effect.particle.ParticleType)type, Map.of(org.spongepowered.api.effect.particle.ParticleOptions.BLOCK_STATE.get(), blockOptions.getState()));
        }
        if (effect instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions dustColorTransitionOptions = (DustColorTransitionOptions)effect;
            return new SpongeParticleEffect((org.spongepowered.api.effect.particle.ParticleType)type, Map.of(org.spongepowered.api.effect.particle.ParticleOptions.COLOR.get(), Color.of(Vector3f.from((float)dustColorTransitionOptions.getFromColor().x, (float)dustColorTransitionOptions.getFromColor().y, (float)dustColorTransitionOptions.getFromColor().z).mul(255.0f)), org.spongepowered.api.effect.particle.ParticleOptions.TO_COLOR.get(), Color.of(Vector3f.from((float)dustColorTransitionOptions.getToColor().x, (float)dustColorTransitionOptions.getToColor().y, (float)dustColorTransitionOptions.getToColor().z).mul(255.0f)), org.spongepowered.api.effect.particle.ParticleOptions.SCALE.get(), Float.valueOf(dustColorTransitionOptions.getScale())));
        }
        if (effect instanceof DustParticleOptions) {
            DustParticleOptions dustOptions = (DustParticleOptions)effect;
            return new SpongeParticleEffect((org.spongepowered.api.effect.particle.ParticleType)type, Map.of(org.spongepowered.api.effect.particle.ParticleOptions.COLOR.get(), Color.of(Vector3f.from((float)dustOptions.getColor().x, (float)dustOptions.getColor().y, (float)dustOptions.getColor().z).mul(255.0f)), org.spongepowered.api.effect.particle.ParticleOptions.SCALE.get(), Float.valueOf(dustOptions.getScale())));
        }
        if (effect instanceof ItemParticleOption) {
            ItemParticleOption itemOptions = (ItemParticleOption)effect;
            return new SpongeParticleEffect((org.spongepowered.api.effect.particle.ParticleType)type, Map.of(org.spongepowered.api.effect.particle.ParticleOptions.BLOCK_STATE.get(), itemOptions.getItem().copy()));
        }
        if (effect instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions sculkChargeOptions = (SculkChargeParticleOptions)effect;
            return new SpongeParticleEffect((org.spongepowered.api.effect.particle.ParticleType)type, Map.of(org.spongepowered.api.effect.particle.ParticleOptions.ROLL.get(), Float.valueOf(sculkChargeOptions.roll())));
        }
        if (effect instanceof ShriekParticleOption) {
            ShriekParticleOption shriekOption = (ShriekParticleOption)effect;
            return new SpongeParticleEffect((org.spongepowered.api.effect.particle.ParticleType)type, Map.of(org.spongepowered.api.effect.particle.ParticleOptions.DELAY.get(), shriekOption.getDelay()));
        }
        if (effect instanceof VibrationParticleOption) {
            VibrationParticleOption vibrationOptions = (VibrationParticleOption)effect;
            return new SpongeParticleEffect((org.spongepowered.api.effect.particle.ParticleType)type, Map.of(org.spongepowered.api.effect.particle.ParticleOptions.TRAVEL_TIME.get(), Ticks.of(vibrationOptions.getArrivalInTicks())));
        }
        return new SpongeParticleEffect((org.spongepowered.api.effect.particle.ParticleType)type, Collections.emptyMap());
    }

    private static final class NamedCachedPacket
    implements CachedParticlePacket {
        private final ParticleOptions particleData;
        private final Vector3f offset;
        private final int quantity;
        private final Vector3f velocity;

        public NamedCachedPacket(ParticleOptions particleData, Vector3f offset, int quantity, Vector3f velocity) {
            this.particleData = particleData;
            this.offset = offset;
            this.quantity = quantity;
            this.velocity = velocity;
        }

        @Override
        public void process(Vector3d position, List<Packet<?>> output) {
            float posX = (float)position.x();
            float posY = (float)position.y();
            float posZ = (float)position.z();
            float offX = this.offset.x();
            float offY = this.offset.y();
            float offZ = this.offset.z();
            if (this.velocity.equals((Object)Vector3f.ZERO)) {
                ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(this.particleData, true, (double)posX, (double)posY, (double)posZ, offX, offY, offZ, 0.0f, this.quantity);
                output.add((Packet<?>)packet);
            } else {
                float velocityX = this.velocity.x();
                float velocityY = this.velocity.y();
                float velocityZ = this.velocity.z();
                Random random = new Random();
                for (int i = 0; i < this.quantity; ++i) {
                    float px0 = posX + (random.nextFloat() * 2.0f - 1.0f) * offX;
                    float py0 = posY + (random.nextFloat() * 2.0f - 1.0f) * offY;
                    float pz0 = posZ + (random.nextFloat() * 2.0f - 1.0f) * offZ;
                    ClientboundLevelParticlesPacket message = new ClientboundLevelParticlesPacket(this.particleData, true, (double)px0, (double)py0, (double)pz0, velocityX, velocityY, velocityZ, 1.0f, 0);
                    output.add((Packet<?>)message);
                }
            }
        }

        @Override
        public @Nullable ParticleOptions particleOptions() {
            return this.particleData;
        }
    }

    private static final class EmptyCachedPacket
    implements CachedParticlePacket {
        public static final EmptyCachedPacket INSTANCE = new EmptyCachedPacket();

        private EmptyCachedPacket() {
        }

        @Override
        public void process(Vector3d position, List<Packet<?>> output) {
        }

        @Override
        public @Nullable ParticleOptions particleOptions() {
            return null;
        }
    }
}

