/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;

public abstract class PooledPhaseState<C extends PhaseContext<C>>
implements IPhaseState<C> {
    private transient @Nullable C serverCached;
    private @Nullable C clientCached;

    protected PooledPhaseState() {
    }

    @Override
    public final C createPhaseContext(PhaseTracker tracker) {
        PhaseContext peek;
        if (Thread.currentThread() != tracker.getSidedThread()) {
            throw new IllegalStateException("Asynchronous Thread Access to PhaseTracker: " + String.valueOf(tracker));
        }
        if (tracker == PhaseTracker.SERVER) {
            if (this.serverCached != null) {
                C cached = this.serverCached;
                this.serverCached = null;
                return cached;
            }
        } else if (tracker == PhaseTracker.CLIENT && this.clientCached != null) {
            C cached = this.clientCached;
            this.clientCached = null;
            return cached;
        }
        if ((peek = (PhaseContext)tracker.getContextPoolFor(this).pollFirst()) != null) {
            return (C)peek;
        }
        return this.createNewContext(tracker);
    }

    final void releaseContextFromPool(C context) {
        PhaseTracker createdTracker = ((PhaseContext)context).createdTracker;
        if (Thread.currentThread() != createdTracker.getSidedThread()) {
            throw new IllegalStateException("Asynchronous Thread Access to PhaseTracker: " + String.valueOf(createdTracker));
        }
        if (createdTracker == PhaseTracker.SERVER) {
            if (this.serverCached == null) {
                this.serverCached = context;
                return;
            }
        } else if (createdTracker == PhaseTracker.CLIENT && this.clientCached == null) {
            this.clientCached = context;
            return;
        }
        createdTracker.getContextPoolFor(this).push(context);
    }

    protected abstract C createNewContext(PhaseTracker var1);
}

