/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.ticks.ScheduledTick;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.StatefulTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.AddBlockEventTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.AddTileEntity;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.block.NeighborNotification;
import org.spongepowered.common.event.tracking.context.transaction.block.PrepareBlockDropsTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.RemoveBlockEntity;
import org.spongepowered.common.event.tracking.context.transaction.block.ReplaceBlockEntity;
import org.spongepowered.common.event.tracking.context.transaction.block.ScheduleUpdateTransaction;
import org.spongepowered.common.event.tracking.context.transaction.effect.EntityPerformingDropsEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.InventoryEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.PrepareBlockDrops;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ClickCreativeMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ClickMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CloseMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerSlotTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CraftingPreviewTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CraftingTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.DropFromPlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ExplicitInventoryOmittedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.InventoryTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.OpenMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlaceRecipeTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SelectTradeTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SetCarriedItemTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SetPlayerContainerTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ShiftCraftingResultTransaction;
import org.spongepowered.common.event.tracking.context.transaction.world.EntityPerformingDropsTransaction;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.volume.VolumeStreamUtils;

interface TransactionSink {
    @Deprecated
    public void logTransaction(StatefulTransaction var1);

    public EffectTransactor pushEffect(ResultingTransactionBySideEffect var1);

    default public ChangeBlock logBlockChange(SpongeBlockSnapshot originalBlockSnapshot, BlockState newState, BlockChangeFlag flags) {
        ChangeBlock changeBlock = new ChangeBlock(originalBlockSnapshot, newState, (SpongeBlockChangeFlag)flags);
        this.logTransaction(changeBlock);
        return changeBlock;
    }

    default public void logBlockEvent(BlockState state, TrackedWorldBridge serverWorld, BlockPos pos, TrackableBlockEventDataBridge blockEvent) {
        WeakReference<ServerLevel> worldRef = new WeakReference<ServerLevel>((ServerLevel)serverWorld);
        Supplier<ServerLevel> worldSupplier = () -> Objects.requireNonNull((ServerLevel)worldRef.get(), "ServerWorld dereferenced");
        @Nullable BlockEntity tileEntity = ((ServerLevel)serverWorld).getBlockEntity(pos);
        SpongeBlockSnapshot original = TrackingUtil.createPooledSnapshot(state, pos, BlockChangeFlags.NONE, 512, tileEntity, worldSupplier, Optional::empty, Optional::empty);
        original.blockChange = BlockChange.MODIFY;
        AddBlockEventTransaction transaction = new AddBlockEventTransaction(original, blockEvent);
        this.logTransaction(transaction);
    }

    default public EffectTransactor logBlockDrops(Level serverWorld, BlockPos pos, BlockState state, @Nullable BlockEntity tileEntity) {
        WeakReference<ServerLevel> worldRef = new WeakReference<ServerLevel>((ServerLevel)serverWorld);
        Supplier<ServerLevel> worldSupplier = () -> Objects.requireNonNull((ServerLevel)worldRef.get(), "ServerWorld dereferenced");
        SpongeBlockSnapshot original = TrackingUtil.createPooledSnapshot(state, pos, BlockChangeFlags.NONE, 512, tileEntity, worldSupplier, Optional::empty, Optional::empty);
        original.blockChange = BlockChange.MODIFY;
        PrepareBlockDropsTransaction transaction = new PrepareBlockDropsTransaction(pos, state, original);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(PrepareBlockDrops.getInstance()));
    }

    default public void logScheduledUpdate(ServerLevel serverWorld, ScheduledTick<?> data) {
        WeakReference<ServerLevel> worldRef = new WeakReference<ServerLevel>(serverWorld);
        Supplier<ServerLevel> worldSupplier = () -> Objects.requireNonNull((ServerLevel)worldRef.get(), "ServerWorld dereferenced");
        @Nullable BlockEntity tileEntity = serverWorld.getBlockEntity(data.pos());
        BlockState existing = serverWorld.getBlockState(data.pos());
        SpongeBlockSnapshot original = TrackingUtil.createPooledSnapshot(existing, data.pos(), BlockChangeFlags.NONE, 512, tileEntity, worldSupplier, Optional::empty, Optional::empty);
        original.blockChange = BlockChange.MODIFY;
        ScheduleUpdateTransaction transaction = new ScheduleUpdateTransaction(original, data);
        this.logTransaction(transaction);
    }

    default public void logNeighborNotification(Supplier<ServerLevel> serverWorldSupplier, BlockPos immutableFrom, Block blockIn, BlockPos immutableTarget, BlockState targetBlockState, @Nullable BlockEntity existingTile) {
        NeighborNotification notificationTransaction = new NeighborNotification(serverWorldSupplier, targetBlockState, immutableTarget, blockIn, immutableFrom, existingTile);
        this.logTransaction(notificationTransaction);
    }

    default public void logEntitySpawn(PhaseContext<@NonNull ?> current, TrackedWorldBridge serverWorld, Entity entityIn) {
        WeakReference<ServerLevel> worldRef = new WeakReference<ServerLevel>((ServerLevel)serverWorld);
        Supplier<ServerLevel> worldSupplier = () -> Objects.requireNonNull((ServerLevel)worldRef.get(), "ServerWorld dereferenced");
        Supplier<SpawnType> contextualType = current.getSpawnTypeForTransaction(entityIn);
        SpawnEntityTransaction transaction = new SpawnEntityTransaction(worldSupplier, entityIn, contextualType);
        this.logTransaction(transaction);
    }

    default public boolean logTileReplacement(BlockPos pos, @Nullable BlockEntity existing, @Nullable BlockEntity proposed, Supplier<ServerLevel> worldSupplier) {
        if (proposed == null) {
            return false;
        }
        this.logTransaction(new ReplaceBlockEntity(pos, existing, proposed, worldSupplier));
        return true;
    }

    default public boolean logTileAddition(BlockEntity tileEntity, Supplier<ServerLevel> worldSupplier, LevelChunk chunk) {
        this.logTransaction(this.createTileAdditionTransaction(tileEntity, worldSupplier, chunk));
        return true;
    }

    default public AddTileEntity createTileAdditionTransaction(BlockEntity tileentity, Supplier<ServerLevel> worldSupplier, LevelChunk chunk) {
        Supplier<LevelChunk> weaklyReferencedSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(chunk, "LevelChunk");
        return new AddTileEntity(tileentity, worldSupplier, weaklyReferencedSupplier);
    }

    default public boolean logTileRemoval(@Nullable BlockEntity tileentity, Supplier<ServerLevel> worldSupplier) {
        if (tileentity == null) {
            return false;
        }
        this.logTransaction(new RemoveBlockEntity(tileentity, worldSupplier));
        return true;
    }

    default public @Nullable EffectTransactor ensureEntityDropTransactionEffect(Entity entity) {
        EntityPerformingDropsTransaction transaction = new EntityPerformingDropsTransaction(entity);
        this.logTransaction(transaction);
        if (transaction.recorded()) {
            return this.pushEffect(new ResultingTransactionBySideEffect(EntityPerformingDropsEffect.getInstance()));
        }
        return null;
    }

    default public void logSlotTransaction(PhaseContext<@NonNull ?> phaseContext, SlotTransaction newTransaction, AbstractContainerMenu abstractContainerMenu) {
        if (abstractContainerMenu instanceof InventoryMenu) {
            if (phaseContext instanceof UnwindingPhaseContext) {
                return;
            }
            if (phaseContext instanceof EntityTickContext) {
                SpongeCommon.logger().warn("Ignoring slot transaction on InventoryMenu during {}. {}\nNo Event will be fired for this", (Object)phaseContext.getClass().getSimpleName(), (Object)newTransaction);
                return;
            }
        }
        ContainerSlotTransaction transaction = new ContainerSlotTransaction(abstractContainerMenu, newTransaction);
        this.logTransaction(transaction);
    }

    default public void logPlayerCarriedItem(Player player, int newSlot) {
        SetCarriedItemTransaction transaction = new SetCarriedItemTransaction(player, newSlot);
        this.logTransaction(transaction);
    }

    default public void logPlayerInventoryChange(Player player, PlayerInventoryTransaction.EventCreator eventCreator) {
        PlayerInventoryTransaction transaction = new PlayerInventoryTransaction(player, eventCreator);
        this.logTransaction(transaction);
    }

    default public EffectTransactor logClickContainer(AbstractContainerMenu menu, int slotNum, int buttonNum, ClickType clickType, Player player) {
        Slot slot = null;
        if (buttonNum >= 0) {
            slot = ((InventoryAdapter)menu).inventoryAdapter$getSlot(slotNum).orElse(null);
        }
        ClickMenuTransaction transaction = new ClickMenuTransaction(player, menu, slotNum, buttonNum, clickType, slot, ItemStackUtil.snapshotOf(player.containerMenu.getCarried()));
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logPlayerInventoryChangeWithEffect(Player player, PlayerInventoryTransaction.EventCreator eventCreator) {
        PlayerInventoryTransaction transaction = new PlayerInventoryTransaction(player, eventCreator);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logCreativeClickContainer(int slotNum, ItemStackSnapshot creativeStack, Player player) {
        ClickCreativeMenuTransaction transaction = new ClickCreativeMenuTransaction(player, slotNum, creativeStack);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logDropFromPlayerInventory(ServerPlayer player, boolean dropAll) {
        DropFromPlayerInventoryTransaction transaction = new DropFromPlayerInventoryTransaction(player, dropAll);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logOpenInventory(Player player) {
        OpenMenuTransaction transaction = new OpenMenuTransaction(player);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logCloseInventory(Player player, boolean clientSource) {
        CloseMenuTransaction transaction = new CloseMenuTransaction(player, clientSource);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logPlaceRecipe(boolean shift, RecipeHolder<Recipe<?>> recipe, ServerPlayer player, CraftingInventory craftInv) {
        PlaceRecipeTransaction transaction = new PlaceRecipeTransaction(player, shift, recipe, craftInv);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public void logSelectTrade(ServerPlayer player, int item) {
        SelectTradeTransaction transaction = new SelectTradeTransaction(player, item);
        this.logTransaction(transaction);
    }

    default public void logShiftCraftingResult(net.minecraft.world.inventory.Slot slot, ItemStack result) {
        ShiftCraftingResultTransaction transaction = new ShiftCraftingResultTransaction(slot, result);
        this.logTransaction(transaction);
    }

    default public void logContainerSet(Player player) {
        SetPlayerContainerTransaction transaction = new SetPlayerContainerTransaction(player);
        this.logTransaction(transaction);
    }

    default public void logCraftingPreview(ServerPlayer player, CraftingInventory craftingInventory, CraftingContainer craftSlots) {
        CraftingPreviewTransaction transaction = new CraftingPreviewTransaction(player, craftingInventory, craftSlots);
        this.logTransaction(transaction);
    }

    default public void logCrafting(Player player, @Nullable ItemStack craftedStack, CraftingInventory craftInv, @Nullable RecipeHolder<CraftingRecipe> lastRecipe) {
        CraftingTransaction transaction = new CraftingTransaction(player, craftedStack, craftInv, lastRecipe);
        this.logTransaction(transaction);
    }

    default public EffectTransactor logIgnoredInventory(AbstractContainerMenu containerMenu) {
        ExplicitInventoryOmittedTransaction transaction = new ExplicitInventoryOmittedTransaction(containerMenu);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logInventoryTransaction(AbstractContainerMenu containerMenu) {
        InventoryTransaction transaction = new InventoryTransaction((Inventory)containerMenu);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }
}

