/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.accessor.world.level.chunk.LevelChunkAccessor;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class UpdateOrCreateNewTileEntityPostPlacementEffect
implements ProcessingSideEffect {
    UpdateOrCreateNewTileEntityPostPlacementEffect() {
    }

    public static UpdateOrCreateNewTileEntityPostPlacementEffect getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        ServerLevel serverWorld = pipeline.getServerWorld();
        LevelChunk chunk = pipeline.getAffectedChunk();
        if (((BlockStateBridge)newState).bridge$hasTileEntity()) {
            @Nullable BlockEntity maybeNewTileEntity = chunk.getBlockEntity(oldState.pos, LevelChunk.EntityCreationType.CHECK);
            if (maybeNewTileEntity == null) {
                @Nullable BlockEntity newBlockEntity = ((BlockStateBridge)newState).bridge$createNewTileEntity((Level)serverWorld, oldState.pos);
                if (newBlockEntity != null) {
                    chunk.addAndRegisterBlockEntity(newBlockEntity);
                }
            } else {
                maybeNewTileEntity.setBlockState(newState);
                ((LevelChunkAccessor)chunk).accessor$updateBlockEntityTicker(maybeNewTileEntity);
            }
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final UpdateOrCreateNewTileEntityPostPlacementEffect INSTANCE = new UpdateOrCreateNewTileEntityPostPlacementEffect();

        private Holder() {
        }
    }
}

