/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class AttackEntityPacketState
extends BasicPacketState {
    private final BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> ATTACK_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.USED_ITEM, ctx.getItemUsedSnapshot());
        ServerboundInteractPacket useEntityPacket = (ServerboundInteractPacket)ctx.getPacket();
        ServerPlayer player = ctx.getPacketPlayer();
        @Nullable net.minecraft.world.entity.Entity entity = useEntityPacket.getTarget(player.serverLevel());
        if (entity != null) {
            frame.addContext(EventContextKeys.USED_HAND, ctx.getHandUsed());
            frame.pushCause(entity);
        }
        frame.pushCause(player);
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.ATTACK_MODIFIER;
    }

    @Override
    public boolean isPacketIgnored(Packet<?> packetIn, ServerPlayer packetPlayer) {
        ServerboundInteractPacket useEntityPacket = (ServerboundInteractPacket)packetIn;
        @Nullable net.minecraft.world.entity.Entity entity = useEntityPacket.getTarget((ServerLevel)packetPlayer.level());
        return entity == null;
    }

    @Override
    public void populateContext(ServerPlayer playerMP, Packet<?> packet, BasicPacketContext context) {
        ((BasicPacketContext)context.itemUsed(ItemStackUtil.cloneDefensive(playerMP.getMainHandItem()))).handUsed(HandTypes.MAIN_HAND.get());
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BasicPacketContext context, net.minecraft.world.entity.Entity entityToSpawn) {
        ServerPlayer player;
        ServerboundInteractPacket useEntityPacket = (ServerboundInteractPacket)context.getPacket();
        @Nullable net.minecraft.world.entity.Entity entity = useEntityPacket.getTarget((player = context.getPacketPlayer()).serverLevel());
        if (entity != null && (entity.isRemoved() || entity instanceof LivingEntity && ((LivingEntity)entity).isDeadOrDying())) {
            return entityToSpawn instanceof ExperienceOrb ? SpawnTypes.EXPERIENCE : SpawnTypes.DROPPED_ITEM;
        }
        if (entityToSpawn instanceof ItemEntity) {
            return SpawnTypes.DROPPED_ITEM;
        }
        return super.getSpawnTypeForTransaction(context, entityToSpawn);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        ServerPlayer player;
        ServerboundInteractPacket useEntityPacket;
        net.minecraft.world.entity.Entity entity;
        if (!TrackingUtil.processBlockCaptures(context) && (entity = (useEntityPacket = (ServerboundInteractPacket)context.getPacket()).getTarget((player = context.getPacketPlayer()).serverLevel())) instanceof Entity) {
            ((Entity)entity).offer(Keys.NOTIFIER, player.getUUID());
        }
    }
}

