/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.entity.living.Ageable;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.accessor.world.entity.decoration.ItemFrameAccessor;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.TrackableEntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class EntityTickPhaseState
extends TickPhaseState<EntityTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, EntityTickContext> ENTITY_TICK_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        Entity tickingEntity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        ((TrackableEntityBridge)((Object)tickingEntity)).tracker$populateFrameInTickContext((CauseStackManager.StackFrame)frame, (EntityTickContext)context);
        frame.pushCause(tickingEntity);
    });

    EntityTickPhaseState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, EntityTickContext> getFrameModifier() {
        return this.ENTITY_TICK_MODIFIER;
    }

    @Override
    public void unwind(EntityTickContext phaseContext) {
        Entity tickingEntity = phaseContext.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", phaseContext));
        if (!TrackingUtil.processBlockCaptures(phaseContext)) {
            ((EntityBridge)((Object)tickingEntity)).bridge$onCancelledBlockChange(phaseContext);
        }
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(EntityTickContext context, net.minecraft.world.entity.Entity entityToSpawn) {
        if (entityToSpawn instanceof ExperienceOrb) {
            return SpawnTypes.EXPERIENCE;
        }
        if (entityToSpawn instanceof Projectile) {
            return SpawnTypes.PROJECTILE;
        }
        Entity source = context.getSource(Entity.class).orElseThrow(() -> new IllegalStateException("Ticking over a non Entity"));
        if (source instanceof Ageable && source.getClass() == entityToSpawn.getClass()) {
            return SpawnTypes.BREEDING;
        }
        return super.getSpawnTypeForTransaction(context, entityToSpawn);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(EntityTickContext context) {
        net.minecraft.world.entity.Entity entity = context.getSource(net.minecraft.world.entity.Entity.class).orElseThrow(() -> new IllegalStateException("Expected to be ticking an entity, but we're not ticking an entity"));
        if (entity.level().isClientSide) {
            return () -> {
                throw new IllegalStateException("attempting a world key on the client???");
            };
        }
        return () -> (ResourceKey)entity.level().dimension().location();
    }

    @Override
    protected EntityTickContext createNewContext(PhaseTracker tracker) {
        return new EntityTickContext(this, tracker);
    }

    @Override
    public void postBlockTransactionApplication(EntityTickContext context, BlockChange blockChange, BlockTransactionReceipt transaction) {
        if (blockChange == BlockChange.BREAK) {
            Entity tickingEntity = context.getSource(Entity.class).get();
            BlockPos blockPos = VecHelper.toBlockPos(transaction.originalBlock().position());
            Vec3 aabbBase = VecHelper.toVanillaVector3d(transaction.originalBlock().position().toDouble());
            List hangingEntities = ((ServerLevel)tickingEntity.world()).getEntitiesOfClass(HangingEntity.class, new AABB(aabbBase, aabbBase).inflate(1.1, 1.1, 1.1), entityIn -> {
                if (entityIn == null) {
                    return false;
                }
                BlockPos entityPos = entityIn.getPos();
                if (entityPos.equals((Object)blockPos.offset(0, 1, 0))) {
                    return true;
                }
                Direction entityFacing = entityIn.getDirection();
                if (entityFacing == Direction.NORTH) {
                    return entityPos.equals((Object)blockPos.offset((Vec3i)Constants.Entity.HANGING_OFFSET_NORTH));
                }
                if (entityFacing == Direction.SOUTH) {
                    return entityIn.getPos().equals((Object)blockPos.offset((Vec3i)Constants.Entity.HANGING_OFFSET_SOUTH));
                }
                if (entityFacing == Direction.WEST) {
                    return entityIn.getPos().equals((Object)blockPos.offset((Vec3i)Constants.Entity.HANGING_OFFSET_WEST));
                }
                if (entityFacing == Direction.EAST) {
                    return entityIn.getPos().equals((Object)blockPos.offset((Vec3i)Constants.Entity.HANGING_OFFSET_EAST));
                }
                return false;
            });
            for (HangingEntity entityHanging : hangingEntities) {
                if (!(entityHanging instanceof ItemFrame)) continue;
                ItemFrame itemFrame = (ItemFrame)entityHanging;
                if (!itemFrame.isRemoved()) {
                    ((ItemFrameAccessor)itemFrame).invoker$dropItem((net.minecraft.world.entity.Entity)tickingEntity, true);
                }
                itemFrame.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, EntityTickContext context) {
        if (!context.applyNotifierIfAvailable(explosionContext::creator)) {
            context.applyOwnerIfAvailable(explosionContext::creator);
        }
        explosionContext.source(context.getSource(Entity.class).orElseThrow(() -> new IllegalStateException("Ticking a non Entity")));
    }

    @Override
    public boolean doesBlockEventTracking(EntityTickContext context) {
        return context.allowsBlockEvents();
    }
}

