/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.LecternMenu;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.SmokerMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.api.item.inventory.ContainerTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.type.ViewableInventory;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.common.inventory.custom.ViewableCustomInventory;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.LensCreator;
import org.spongepowered.common.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.inventory.lens.impl.LensRegistrar;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.BrewingStandInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.FurnaceInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.math.vector.Vector2i;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeViewableInventoryBuilder
implements ViewableInventory.Builder,
ViewableInventory.Builder.DummyStep,
ViewableInventory.Builder.EndStep {
    private ContainerType type;
    private Map<Integer, Slot> slotDefinitions;
    private Slot lastSlot;
    private PluginContainer plugin;
    private Carrier carrier;
    private UUID identity;
    private List<Inventory> finalInventories;
    private Lens finalLens;
    private SlotLensProvider finalProvider;
    private ContainerTypeInfo info;
    private static Map<ContainerType, ContainerTypeInfo> containerTypeInfo;

    @Override
    public ViewableInventory.Builder.BuildingStep type(ContainerType type) {
        Validate.isTrue((boolean)SpongeViewableInventoryBuilder.containerTypeInfo().containsKey(type), (String)("Container Type cannot be used for this: " + String.valueOf(type)), (Object[])new Object[0]);
        this.type = type;
        this.slotDefinitions = new HashMap<Integer, Slot>();
        this.info = SpongeViewableInventoryBuilder.containerTypeInfo().get(type);
        return this;
    }

    private int posToIndex(Vector2i pos) {
        return this.posToIndex(pos.x(), pos.y());
    }

    private int posToIndex(int x, int y) {
        Validate.isTrue((x <= this.info.width ? 1 : 0) != 0, (String)("Target inventory is too small: " + this.info.width + " < " + x), (Object[])new Object[0]);
        Validate.isTrue((y <= this.info.height ? 1 : 0) != 0, (String)("Target inventory is too small: " + this.info.height + " < " + y), (Object[])new Object[0]);
        return y * this.info.width + x;
    }

    private Vector2i indexToPos(int offset) {
        Validate.isTrue((offset <= this.info.width * this.info.height ? 1 : 0) != 0, (String)("Target inventory is too small: " + this.info.width * this.info.height + " < " + offset), (Object[])new Object[0]);
        int x = offset / this.info.height;
        int y = offset % this.info.width;
        return new Vector2i(x, y);
    }

    private Slot newDummySlot() {
        SimpleContainer dummyInv = new SimpleContainer(1);
        return ((Inventory)dummyInv).slot(0).get();
    }

    @Override
    public ViewableInventory.Builder.BuildingStep slotsAtIndizes(List<Slot> source, List<Integer> at) {
        Validate.isTrue((source.size() == at.size() ? 1 : 0) != 0, (String)"Source and index list sizes differ", (Object[])new Object[0]);
        for (int i = 0; i < at.size(); ++i) {
            Slot slot = source.get(i);
            Integer index = at.get(i);
            this.slotDefinitions.put(index, slot);
            this.lastSlot = slot;
        }
        return this;
    }

    @Override
    public ViewableInventory.Builder.BuildingStep slotsAtPositions(List<Slot> source, List<Vector2i> at) {
        return this.slotsAtIndizes(source, at.stream().map(this::posToIndex).collect(Collectors.toList()));
    }

    @Override
    public ViewableInventory.Builder.DummyStep fillDummy() {
        Slot slot = this.newDummySlot();
        List<Integer> indizes = IntStream.range(0, this.info.size).boxed().filter(idx -> !this.slotDefinitions.containsKey(idx)).collect(Collectors.toList());
        List<Slot> source = Stream.generate(() -> slot).limit(indizes.size()).collect(Collectors.toList());
        this.slotsAtIndizes(source, indizes);
        return this;
    }

    @Override
    public ViewableInventory.Builder.DummyStep dummySlots(int count, int offset) {
        Slot slot = this.newDummySlot();
        List<Slot> source = Stream.generate(() -> slot).limit(count).collect(Collectors.toList());
        this.slots(source, offset);
        return this;
    }

    @Override
    public ViewableInventory.Builder.BuildingStep slots(List<Slot> source, int offset) {
        List<Integer> indizes = IntStream.range(offset, offset + source.size()).boxed().collect(Collectors.toList());
        return this.slotsAtIndizes(source, indizes);
    }

    @Override
    public ViewableInventory.Builder.DummyStep dummyGrid(Vector2i size, Vector2i offset) {
        Slot slot = this.newDummySlot();
        List<Slot> source = Stream.generate(() -> slot).limit(size.x() * size.y()).collect(Collectors.toList());
        this.grid(source, size, offset);
        return this;
    }

    @Override
    public ViewableInventory.Builder.BuildingStep grid(List<Slot> source, Vector2i size, Vector2i offset) {
        int xMin = offset.x();
        int yMin = offset.y();
        int xMax = xMin + size.x() - 1;
        int yMax = yMin + size.y() - 1;
        ArrayList<Integer> indizes = new ArrayList<Integer>();
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                indizes.add(this.posToIndex(x, y));
            }
        }
        return this.slotsAtIndizes(source, indizes);
    }

    @Override
    public ViewableInventory.Builder.DummyStep dummySlots(int count, Vector2i offset) {
        return this.dummySlots(count, this.posToIndex(offset));
    }

    @Override
    public ViewableInventory.Builder.BuildingStep slots(List<Slot> source, Vector2i offset) {
        return this.slots(source, this.posToIndex(offset));
    }

    @Override
    public ViewableInventory.Builder.DummyStep dummyGrid(Vector2i size, int offset) {
        return this.dummyGrid(size, this.indexToPos(offset));
    }

    @Override
    public ViewableInventory.Builder.BuildingStep grid(List<Slot> source, Vector2i size, int offset) {
        return this.grid(source, size, this.indexToPos(offset));
    }

    @Override
    public ViewableInventory.Builder.BuildingStep item(ItemStackSnapshot item) {
        this.lastSlot.set(item.createStack());
        return this;
    }

    @Override
    public ViewableInventory.Builder.EndStep plugin(PluginContainer plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        return this;
    }

    @Override
    public ViewableInventory.Builder.EndStep identity(UUID uuid) {
        this.identity = uuid;
        return this;
    }

    @Override
    public ViewableInventory.Builder.EndStep carrier(Carrier carrier) {
        this.carrier = carrier;
        return this;
    }

    @Override
    public ViewableInventory.Builder.EndStep completeStructure() {
        if (!this.slotDefinitions.isEmpty()) {
            this.fillDummy();
            this.finalInventories = this.slotDefinitions.values().stream().map(Inventory.class::cast).collect(Collectors.toList());
        }
        this.finalProvider = new LensRegistrar.BasicSlotLensProvider(this.info.size);
        this.finalLens = SpongeViewableInventoryBuilder.containerTypeInfo().get((Object)this.type).lensCreator.createLens(this.finalProvider);
        return this;
    }

    @Override
    public ViewableInventory.Custom build() {
        ValueContainer inventory;
        if (this.plugin == null) {
            throw new IllegalStateException("Plugin has not been set on this builder!");
        }
        if (this.slotDefinitions.isEmpty() && this.info.size != 0) {
            inventory = Inventory.builder().slots(this.info.size).completeStructure().plugin(this.plugin).build();
            this.finalInventories = Arrays.asList(inventory);
        }
        inventory = new ViewableCustomInventory(this.plugin, this.type, SpongeViewableInventoryBuilder.containerTypeInfo().get(this.type), this.info.size, this.finalLens, this.finalProvider, this.finalInventories, this.identity, this.carrier);
        if (this.slotDefinitions.isEmpty()) {
            ((ViewableCustomInventory)inventory).vanilla();
        }
        return (ViewableInventory.Custom)inventory;
    }

    @Override
    public ViewableInventory.Builder reset() {
        this.plugin = null;
        this.type = null;
        this.info = null;
        this.slotDefinitions = null;
        this.lastSlot = null;
        this.carrier = null;
        this.identity = null;
        this.finalInventories = null;
        this.finalLens = null;
        this.finalProvider = null;
        return this;
    }

    public static void register(DefaultedRegistryReference<ContainerType> ref, ContainerTypeInfo info) {
        containerTypeInfo.put(ref.get(), info);
    }

    public static Map<ContainerType, ContainerTypeInfo> containerTypeInfo() {
        if (containerTypeInfo != null) {
            return containerTypeInfo;
        }
        containerTypeInfo = new HashMap<ContainerType, ContainerTypeInfo>();
        SpongeViewableInventoryBuilder.register(ContainerTypes.GENERIC_3X3, ContainerTypeInfo.ofGrid(3, 3, (id, i, p, vi) -> new DispenserMenu(id, i, (Container)vi)));
        SpongeViewableInventoryBuilder.register(ContainerTypes.GENERIC_9X1, ContainerTypeInfo.ofGrid(9, 1, (id, i, p, vi) -> new ChestMenu(MenuType.GENERIC_9x1, id, i, (Container)vi, 1)));
        SpongeViewableInventoryBuilder.register(ContainerTypes.GENERIC_9X2, ContainerTypeInfo.ofGrid(9, 2, (id, i, p, vi) -> new ChestMenu(MenuType.GENERIC_9x2, id, i, (Container)vi, 2)));
        SpongeViewableInventoryBuilder.register(ContainerTypes.GENERIC_9X3, ContainerTypeInfo.ofGrid(9, 3, (id, i, p, vi) -> ChestMenu.threeRows((int)id, (net.minecraft.world.entity.player.Inventory)i, (Container)vi)));
        SpongeViewableInventoryBuilder.register(ContainerTypes.GENERIC_9X4, ContainerTypeInfo.ofGrid(9, 4, (id, i, p, vi) -> new ChestMenu(MenuType.GENERIC_9x4, id, i, (Container)vi, 4)));
        SpongeViewableInventoryBuilder.register(ContainerTypes.GENERIC_9X5, ContainerTypeInfo.ofGrid(9, 5, (id, i, p, vi) -> new ChestMenu(MenuType.GENERIC_9x5, id, i, (Container)vi, 5)));
        SpongeViewableInventoryBuilder.register(ContainerTypes.GENERIC_9X6, ContainerTypeInfo.ofGrid(9, 6, (id, i, p, vi) -> ChestMenu.sixRows((int)id, (net.minecraft.world.entity.player.Inventory)i, (Container)vi)));
        SpongeViewableInventoryBuilder.register(ContainerTypes.HOPPER, ContainerTypeInfo.ofGrid(5, 1, (id, i, p, vi) -> new HopperMenu(id, i, (Container)vi)));
        SpongeViewableInventoryBuilder.register(ContainerTypes.SHULKER_BOX, ContainerTypeInfo.ofGrid(9, 3, (id, i, p, vi) -> new ShulkerBoxMenu(id, i, (Container)vi)));
        SpongeViewableInventoryBuilder.register(ContainerTypes.BLAST_FURNACE, ContainerTypeInfo.of(FurnaceInventoryLens::new, 3, 4, (id, i, p, vi) -> new BlastFurnaceMenu(id, i, (Container)vi, (ContainerData)vi.getData())));
        SpongeViewableInventoryBuilder.register(ContainerTypes.BREWING_STAND, ContainerTypeInfo.of(BrewingStandInventoryLens::new, 5, 2, (id, i, p, vi) -> new BrewingStandMenu(id, i, (Container)vi, (ContainerData)vi.getData())));
        SpongeViewableInventoryBuilder.register(ContainerTypes.FURNACE, ContainerTypeInfo.of(FurnaceInventoryLens::new, 3, 4, (id, i, p, vi) -> new FurnaceMenu(id, i, (Container)vi, (ContainerData)vi.getData())));
        SpongeViewableInventoryBuilder.register(ContainerTypes.LECTERN, ContainerTypeInfo.of(1, 1, (id, i, p, vi) -> new LecternMenu(id, (Container)vi, (ContainerData)vi.getData())));
        SpongeViewableInventoryBuilder.register(ContainerTypes.SMOKER, ContainerTypeInfo.of(3, 4, (id, i, p, vi) -> new SmokerMenu(id, i, (Container)vi, (ContainerData)vi.getData())));
        SpongeViewableInventoryBuilder.register(ContainerTypes.ANVIL, ContainerTypeInfo.of(0, (id, i, p, vi) -> new AnvilMenu(id, i, SpongeViewableInventoryBuilder.toPos(p))));
        SpongeViewableInventoryBuilder.register(ContainerTypes.BEACON, ContainerTypeInfo.of(3, (id, i, p, vi) -> new BeaconMenu(id, (Container)i, (ContainerData)vi.getData(), SpongeViewableInventoryBuilder.toPos(p))));
        SpongeViewableInventoryBuilder.register(ContainerTypes.CARTOGRAPHY_TABLE, ContainerTypeInfo.of(0, (id, i, p, vi) -> new CartographyTableMenu(id, i, SpongeViewableInventoryBuilder.toPos(p))));
        SpongeViewableInventoryBuilder.register(ContainerTypes.CRAFTING, ContainerTypeInfo.of(0, (id, i, p, vi) -> new CraftingMenu(id, i, SpongeViewableInventoryBuilder.toPos(p))));
        SpongeViewableInventoryBuilder.register(ContainerTypes.ENCHANTMENT, ContainerTypeInfo.of(0, (id, i, p, vi) -> new EnchantmentMenu(id, i, SpongeViewableInventoryBuilder.toPos(p))));
        SpongeViewableInventoryBuilder.register(ContainerTypes.GRINDSTONE, ContainerTypeInfo.of(0, (id, i, p, vi) -> new GrindstoneMenu(id, i, SpongeViewableInventoryBuilder.toPos(p))));
        SpongeViewableInventoryBuilder.register(ContainerTypes.LOOM, ContainerTypeInfo.of(0, (id, i, p, vi) -> new LoomMenu(id, i, SpongeViewableInventoryBuilder.toPos(p))));
        SpongeViewableInventoryBuilder.register(ContainerTypes.STONECUTTER, ContainerTypeInfo.of(0, (id, i, p, vi) -> new StonecutterMenu(id, i, SpongeViewableInventoryBuilder.toPos(p))));
        SpongeViewableInventoryBuilder.register(ContainerTypes.MERCHANT, ContainerTypeInfo.of(sp -> new DefaultEmptyLens(), 0, 0, (id, i, p, vi) -> {
            Villager merchant = new Villager(EntityType.VILLAGER, p.level());
            merchant.setPos(p.position());
            merchant.setVillagerData(merchant.getVillagerData().setLevel(5));
            return new MerchantMenu(id, i, vi.applyTradeOffers((Merchant)merchant));
        }));
        AbstractHorse horse = null;
        ContainerTypeInfo.of(0, 0, (id, i, p, vi) -> new HorseInventoryMenu(id, i, (Container)vi, horse));
        return containerTypeInfo;
    }

    private static ContainerLevelAccess toPos(Player p) {
        return ContainerLevelAccess.create((Level)p.level(), (BlockPos)p.blockPosition());
    }

    public static class ContainerTypeInfo {
        public final LensCreator lensCreator;
        public final Supplier<SimpleContainerData> dataProvider;
        public final CustomInventoryContainerProvider containerProvider;
        public final int width;
        public final int height;
        public final int size;

        public ContainerTypeInfo(LensCreator lensCreator, Supplier<SimpleContainerData> dataProvider, CustomInventoryContainerProvider containerProvider, int width, int height, int size) {
            this.lensCreator = lensCreator;
            this.dataProvider = dataProvider;
            this.containerProvider = containerProvider;
            this.width = width;
            this.height = height;
            this.size = size;
        }

        public static ContainerTypeInfo of(LensCreator lensCreator, int size, int dataSize, CustomInventoryContainerProvider provider) {
            return new ContainerTypeInfo(lensCreator, () -> new SimpleContainerData(dataSize), provider, 0, 0, size);
        }

        public static ContainerTypeInfo of(int dataSize, CustomInventoryContainerProvider provider) {
            return new ContainerTypeInfo(sp -> new DefaultEmptyLens(), () -> new SimpleContainerData(dataSize), provider, 0, 0, 0);
        }

        public static ContainerTypeInfo of(int size, int dataSize, CustomInventoryContainerProvider provider) {
            return new ContainerTypeInfo(sp -> new DefaultIndexedLens(0, size, sp), () -> new SimpleContainerData(dataSize), provider, 0, 0, size);
        }

        public static ContainerTypeInfo ofGrid(int width, int height, CustomInventoryContainerProvider provider) {
            return new ContainerTypeInfo(sp -> new GridInventoryLens(0, width, height, sp), () -> null, provider, width, height, width * height);
        }

        public static ContainerTypeInfo ofGrid(int width, int height, int size, CustomInventoryContainerProvider provider) {
            return new ContainerTypeInfo(sp -> new GridInventoryLens(0, width, height, sp), () -> null, provider, width, height, size);
        }
    }

    @FunctionalInterface
    public static interface CustomInventoryContainerProvider {
        public @Nullable AbstractContainerMenu createMenu(int var1, net.minecraft.world.entity.player.Inventory var2, Player var3, ViewableCustomInventory var4);
    }

    public static class CustomSlotProvider
    implements SlotLensProvider {
        private List<SlotLens> lenses = new ArrayList<SlotLens>();

        public void add(SlotLens toAdd) {
            this.lenses.add(toAdd);
        }

        @Override
        public SlotLens getSlotLens(int index) {
            return this.lenses.get(index);
        }
    }
}

