/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.comp;

import org.spongepowered.api.data.Keys;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.adapter.impl.comp.Inventory2DAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.SlotBasedLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.inventory.property.KeyValuePair;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.math.vector.Vector2i;

public class Inventory2DLens
extends SlotBasedLens {
    protected final int width;
    protected final int height;
    protected final int xBase;
    protected final int yBase;

    public Inventory2DLens(int base, int width, int height, SlotLensProvider slots) {
        this(base, width, height, width, Inventory2DAdapter.class, slots);
    }

    public Inventory2DLens(int base, int width, int height, int rowStride, Class<? extends Inventory> adapterType, SlotLensProvider slots) {
        this(base, width, height, rowStride, 0, 0, adapterType, slots);
    }

    protected Inventory2DLens(int base, int width, int height, int rowStride, int xBase, int yBase, Class<? extends Inventory> adapterType, SlotLensProvider slots) {
        super(base, width * height, rowStride, adapterType, slots);
        Preconditions.checkArgument(width > 0, String.format("Invalid width: %s", width));
        Preconditions.checkArgument(height > 0, String.format("Invalid height: %s", height));
        this.width = width;
        this.height = height;
        this.xBase = xBase;
        this.yBase = yBase;
        this.init(slots);
    }

    private void init(SlotLensProvider slots) {
        int slot = this.base;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                SlotLens slotLens = slots.getSlotLens(slot);
                this.addChild(slotLens, KeyValuePair.of(Keys.SLOT_POSITION, new Vector2i(this.xBase + x, this.yBase + y)));
                ++x;
                slot += this.stride;
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public SlotLens getSlot(Vector2i pos) {
        return (SlotLens)this.spanningChildren.get(pos.x() + pos.y() * this.width);
    }

    @Override
    public Inventory getAdapter(Fabric fabric, Inventory parent) {
        return new Inventory2DAdapter(fabric, this, parent);
    }
}

