/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.util.Constants;

class ItemStackDataComponentsUpdater
implements DataContentUpdater {
    public static final DataContentUpdater INSTANCE = new ItemStackDataComponentsUpdater();

    ItemStackDataComponentsUpdater() {
    }

    @Override
    public int inputVersion() {
        return 2;
    }

    @Override
    public int outputVersion() {
        return 3;
    }

    @Override
    public DataView update(DataView content) {
        int count = content.getInt(Constants.ItemStack.V2.COUNT).get();
        String type = content.getString(Constants.ItemStack.V2.TYPE).get();
        DataContainer updated = DataContainer.createNew();
        updated.set(Constants.ItemStack.TYPE, type);
        updated.set(Constants.ItemStack.COUNT, count);
        DataContainer components = DataContainer.createNew();
        content.getInt(Constants.ItemStack.V2.DAMAGE_VALUE).filter(dmg -> dmg != 0).ifPresent(dmg -> components.set(Constants.ItemStack.DAMAGE, dmg));
        content.getView(Constants.Sponge.UNSAFE_NBT).ifPresent(unsafe -> {
            CompoundTag tag = NBTTranslator.INSTANCE.translate((DataView)unsafe);
            CompoundTag itemStackTag = new CompoundTag();
            itemStackTag.putString("id", type);
            itemStackTag.putInt("Count", count);
            itemStackTag.put("tag", (Tag)tag);
            Dynamic dataFixed = DataFixers.getDataFixer().update(References.ITEM_STACK, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)itemStackTag), 3692, 3833);
            DataContainer newComponents = NBTTranslator.INSTANCE.translate((CompoundTag)dataFixed.getElement("components", (Object)new CompoundTag()));
            newComponents.values(false).forEach(components::set);
        });
        updated.set(Constants.ItemStack.COMPONENTS, components);
        return updated;
    }
}

