/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.event.HoverEvent;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.item.SpongeItemStack;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SpongeItemStackSnapshot
implements ItemStackSnapshot {
    public static final ItemStackSnapshot EMPTY = new SpongeItemStackSnapshot(ItemStackUtil.fromNative(ItemStack.EMPTY));
    private final ItemType itemType;
    private final int quantity;
    private final int damageValue;
    private final ImmutableList<DataManipulator.Immutable> manipulators;
    private final transient org.spongepowered.api.item.inventory.ItemStack privateStack;
    private final ImmutableSet<Key<?>> keys;
    private final ImmutableSet<Value.Immutable<?>> values;
    private final DataComponentPatch components;
    private @Nullable UUID creatorUniqueId;

    public SpongeItemStackSnapshot(org.spongepowered.api.item.inventory.ItemStack itemStack) {
        Objects.requireNonNull(itemStack);
        if (ItemStackUtil.toNative(itemStack) == ItemStack.EMPTY) {
            this.itemType = itemStack.type();
            this.quantity = 0;
            this.damageValue = 0;
            this.manipulators = ImmutableList.of();
            this.privateStack = itemStack;
            this.keys = ImmutableSet.of();
            this.values = ImmutableSet.of();
            this.components = DataComponentPatch.EMPTY;
            return;
        }
        this.itemType = itemStack.type();
        this.quantity = itemStack.quantity();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
        ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
        DataManipulator.Mutable customData = ((SpongeDataHolderBridge)((Object)itemStack)).bridge$getManipulator();
        builder.add((Object)customData.asImmutable());
        keyBuilder.addAll(customData.getKeys());
        valueBuilder.addAll(customData.getValues());
        this.damageValue = ItemStackUtil.toNative(itemStack).getDamageValue();
        this.manipulators = builder.build();
        this.privateStack = itemStack.copy();
        this.keys = keyBuilder.build();
        this.values = valueBuilder.build();
        this.components = ItemStackUtil.toNative(this.privateStack).getComponentsPatch();
    }

    @Override
    public ItemType type() {
        return this.itemType == null ? (ItemType)ItemStack.EMPTY.getItem() : this.itemType;
    }

    @Override
    public int quantity() {
        return this.quantity;
    }

    @Override
    public boolean isEmpty() {
        return this.privateStack.isEmpty();
    }

    public boolean isNone() {
        throw new UnsupportedOperationException("Implement is empty");
    }

    @Override
    public org.spongepowered.api.item.inventory.ItemStack createStack() {
        ItemStack nativeStack = ItemStackUtil.cloneDefensiveNative(ItemStackUtil.toNative(this.privateStack.copy()));
        if (this.components != null) {
            nativeStack.applyComponents(this.components);
        }
        for (DataManipulator.Immutable manipulator : this.manipulators) {
            ((org.spongepowered.api.item.inventory.ItemStack)nativeStack).copyFrom(manipulator);
        }
        return ItemStackUtil.fromNative(nativeStack);
    }

    @Override
    public int contentVersion() {
        return 3;
    }

    @Override
    public DataContainer toContainer() {
        return SpongeItemStack.getDataContainer((ItemStack)this.createStack());
    }

    @Override
    public <E> Optional<ItemStackSnapshot> transform(Key<? extends Value<E>> key, Function<E, E> function) {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.transform(key, function);
        if (result.type() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public <E> Optional<ItemStackSnapshot> with(Key<? extends Value<E>> key, E value) {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.offer(key, value);
        if (result.type() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public Optional<ItemStackSnapshot> with(Value<?> value) {
        return this.with(value.key(), value.get());
    }

    @Override
    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        return this.privateStack.get(key);
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return this.privateStack.getValue(key);
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.privateStack.supports(key);
    }

    @Override
    public ItemStackSnapshot copy() {
        return this;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.keys;
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.values;
    }

    public String toString() {
        ResourceKey resourceKey = Sponge.game().registry(RegistryTypes.ITEM_TYPE).valueKey(this.itemType);
        return new StringJoiner(", ", SpongeItemStackSnapshot.class.getSimpleName() + "[", "]").add("itemType=" + String.valueOf(resourceKey)).add("quantity=" + this.quantity).toString();
    }

    public int getDamageValue() {
        return this.damageValue;
    }

    public DataComponentPatch getComponentsPatch() {
        return this.components;
    }

    public Optional<UUID> getCreator() {
        return Optional.ofNullable(this.creatorUniqueId);
    }

    public void setCreator(@Nullable UUID uuid) {
        if (uuid != null) {
            this.creatorUniqueId = uuid;
        }
    }

    @Override
    public ItemStackSnapshot withRawData(DataView container) throws InvalidDataException {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        copy.setRawData(container);
        return copy.createSnapshot();
    }

    @Override
    public Optional<ItemStackSnapshot> without(Key<?> key) {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.remove(key);
        if (result.type() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public ItemStackSnapshot mergeWith(ItemStackSnapshot that, MergeFunction function) {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        copy.copyFrom(that, function);
        return copy.createSnapshot();
    }

    @Override
    public boolean validateRawData(DataView container) {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        return copy.validateRawData(container);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeItemStackSnapshot that = (SpongeItemStackSnapshot)o;
        return this.quantity == that.quantity && this.damageValue == that.damageValue && Objects.equals(this.itemType, that.itemType) && Objects.equals(this.components, that.components) && Objects.equals(this.creatorUniqueId, that.creatorUniqueId);
    }

    public int hashCode() {
        return Objects.hash(this.itemType, this.quantity, this.damageValue, this.components, this.creatorUniqueId);
    }

    public HoverEvent<HoverEvent.ShowItem> asHoverEvent(UnaryOperator<HoverEvent.ShowItem> op) {
        ResourceKey resourceKey = Sponge.game().registry(RegistryTypes.ITEM_TYPE).valueKey(this.itemType);
        return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.showItem((Keyed)resourceKey, (int)this.quantity(), SpongeAdventure.asAdventure(this.getComponentsPatch())))));
    }
}

