/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmokingRecipe;
import org.spongepowered.common.item.recipe.ResultFunctionRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeSmokingRecipe
extends SmokingRecipe
implements ResultFunctionRecipe {
    private final String resultFunctionId;

    public SpongeSmokingRecipe(String group, CookingBookCategory category, Ingredient ingredient, ItemStack result, float experience, int cookingTime, String resultFunctionId) {
        super(group, category, ingredient, result, experience, cookingTime);
        this.resultFunctionId = resultFunctionId;
    }

    @Override
    public Optional<String> resultFunctionId() {
        return Optional.ofNullable(this.resultFunctionId);
    }

    public ItemStack assemble(Container container, HolderLookup.Provider $$1) {
        if (this.resultFunctionId != null) {
            ItemStack result = IngredientResultUtil.cachedResultFunction(this.resultFunctionId).apply(container);
            result.setCount(1);
            return result;
        }
        return super.assemble(container, $$1);
    }

    public ItemStack getResultItem(HolderLookup.Provider $$1) {
        if (this.resultFunctionId != null) {
            return ItemStack.EMPTY;
        }
        return super.getResultItem($$1);
    }
}

