/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.advancements;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.advancement.SpongeAdvancementTemplate;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.advancements.AdvancementBridge;

@Mixin(value={net.minecraft.advancements.Advancement.class})
public abstract class AdvancementMixin_API
implements Advancement {
    @Shadow
    @Final
    private Optional<ResourceLocation> parent;
    @Shadow
    @Final
    private Optional<net.minecraft.advancements.DisplayInfo> display;
    @Shadow
    @Final
    private AdvancementRewards rewards;
    @Shadow
    @Final
    private Map<String, Criterion<?>> criteria;
    @Shadow
    @Final
    private AdvancementRequirements requirements;
    @Shadow
    @Final
    private Optional<Component> name;

    @Override
    public AdvancementCriterion criterion() {
        return ((AdvancementBridge)((Object)this)).bridge$getCriterion();
    }

    @Override
    public Optional<ResourceKey> parent() {
        return this.parent.map(ResourceKey.class::cast);
    }

    @Override
    public Optional<DisplayInfo> displayInfo() {
        return Optional.ofNullable((DisplayInfo)((Object)this.display));
    }

    @Override
    public List<net.kyori.adventure.text.Component> toToastText() {
        return ((AdvancementBridge)((Object)this)).bridge$getToastText();
    }

    public net.kyori.adventure.text.Component asComponent() {
        return SpongeAdventure.asAdventure(this.name.orElse((Component)Component.literal((String)"no display name")));
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement json = SpongeAdvancementTemplate.encode((net.minecraft.advancements.Advancement)this);
        try {
            DataContainer container = DataFormats.JSON.get().read(json.toString());
            container.set(Queries.CONTENT_VERSION, this.contentVersion());
            return container;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Advancement:\n" + String.valueOf(json), e);
        }
    }
}

