/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.entity;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.entity.projectile.ProjectileUtil;
import org.spongepowered.common.mixin.api.minecraft.world.entity.EntityMixin_API;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_API
extends EntityMixin_API
implements Living {
    @Shadow
    public abstract float shadow$getHealth();

    @Shadow
    public abstract AttributeMap shadow$getAttributes();

    @Override
    public Optional<org.spongepowered.api.entity.attribute.Attribute> attribute(AttributeType type) {
        Objects.requireNonNull(type, "AttributeType cannot be null");
        return Optional.ofNullable((org.spongepowered.api.entity.attribute.Attribute)this.shadow$getAttributes().getInstance(BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)((Attribute)type))));
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.requireValue(Keys.ABSORPTION).asImmutable());
        values.add(this.requireValue(Keys.ACTIVE_ITEM).asImmutable());
        values.add(((MapValue)this.requireValue(Keys.BODY_ROTATIONS)).asImmutable());
        values.add(this.requireValue(Keys.CHEST_ROTATION).asImmutable());
        values.add(this.requireValue(Keys.HEAD_ROTATION).asImmutable());
        values.add(this.requireValue(Keys.HEALTH).asImmutable());
        values.add(this.requireValue(Keys.IS_ELYTRA_FLYING).asImmutable());
        values.add(this.requireValue(Keys.LAST_DAMAGE_RECEIVED).asImmutable());
        values.add(this.requireValue(Keys.MAX_HEALTH).asImmutable());
        values.add(((ListValue)this.requireValue(Keys.POTION_EFFECTS)).asImmutable());
        values.add(this.requireValue(Keys.SCALE).asImmutable());
        values.add(this.requireValue(Keys.STUCK_ARROWS).asImmutable());
        values.add(this.requireValue(Keys.WALKING_SPEED).asImmutable());
        this.getValue(Keys.CAN_GRIEF).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.LAST_ATTACKER).map(Value::asImmutable).ifPresent(values::add);
        return values;
    }

    @Override
    public <T extends Projectile> Optional<T> launchProjectile(EntityType<T> projectileType) {
        return ProjectileUtil.launch(Objects.requireNonNull(projectileType, "projectileType"), this, null);
    }

    @Override
    public <T extends Projectile> Optional<T> launchProjectile(EntityType<T> projectileType, Vector3d velocity) {
        return ProjectileUtil.launch(Objects.requireNonNull(projectileType, "projectileType"), this, Objects.requireNonNull(velocity, "velocity"));
    }

    @Override
    public <T extends Projectile> Optional<T> launchProjectileTo(EntityType<T> projectileType, Entity target) {
        return Optional.empty();
    }
}

