/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.SerializableDataHolder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.item.SpongeItemStack;
import org.spongepowered.common.item.SpongeItemStackSnapshot;

@Mixin(value={ItemStack.class})
@Implements(value={@Interface(iface=org.spongepowered.api.item.inventory.ItemStack.class, prefix="itemStack$", remap=Interface.Remap.NONE)})
public abstract class ItemStackMixin_API
implements SerializableDataHolder.Mutable,
ComponentLike,
HoverEventSource<HoverEvent.ShowItem> {
    @Shadow
    public abstract int shadow$getCount();

    @Shadow
    public abstract void shadow$setCount(int var1);

    @Shadow
    public abstract int shadow$getMaxStackSize();

    @Shadow
    public abstract boolean shadow$isEmpty();

    @Shadow
    public abstract ItemStack shadow$copy();

    @Shadow
    public abstract Item shadow$getItem();

    @Shadow
    public abstract net.minecraft.network.chat.Component shadow$getDisplayName();

    @Shadow
    public abstract void shadow$applyComponents(DataComponentPatch var1);

    @Shadow
    public abstract DataComponentPatch shadow$getComponentsPatch();

    @Shadow
    @Nullable
    public abstract <T> T shadow$update(DataComponentType<T> var1, T var2, UnaryOperator<T> var3);

    public int itemStack$quantity() {
        return this.shadow$getCount();
    }

    public ItemType itemStack$type() {
        return (ItemType)this.shadow$getItem();
    }

    public void itemStack$setQuantity(int quantity) throws IllegalArgumentException {
        this.shadow$setCount(quantity);
    }

    public int itemStack$maxStackQuantity() {
        return this.shadow$getMaxStackSize();
    }

    @Override
    public boolean validateRawData(DataView container) {
        Objects.requireNonNull(container);
        return false;
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container);
        if (this.shadow$isEmpty()) {
            throw new IllegalArgumentException("Cannot set data on empty item stacks!");
        }
        try {
            this.shadow$applyComponents(SpongeItemStack.patchFromData(container));
        }
        catch (Exception e) {
            throw new InvalidDataException("Unable to set raw data or translate raw data for ItemStack setting", e);
        }
    }

    @Override
    public SerializableDataHolder.Mutable copy() {
        return this.itemStack$copy();
    }

    public org.spongepowered.api.item.inventory.ItemStack itemStack$copy() {
        return (org.spongepowered.api.item.inventory.ItemStack)this.shadow$copy();
    }

    public Collection<AttributeModifier> itemStack$attributeModifiers(AttributeType attributeType, EquipmentType equipmentType) {
        Objects.requireNonNull(attributeType, "Attribute type cannot be null");
        Objects.requireNonNull(equipmentType, "Equipment type cannot be null");
        ImmutableList.Builder builder = ImmutableList.builder();
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)((ItemStack)this).getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            if (!((Attribute)entry.attribute().value()).equals(attributeType) || !entry.slot().test((EquipmentSlot)equipmentType)) continue;
            builder.add((Object)((AttributeModifier)entry.modifier()));
        }
        return builder.build();
    }

    public void itemStack$addAttributeModifier(AttributeType attributeType, AttributeModifier modifier, EquipmentType equipmentType) {
        Objects.requireNonNull(attributeType, "Attribute type cannot be null");
        Objects.requireNonNull(modifier, "Attribute modifier cannot be null");
        Objects.requireNonNull(equipmentType, "Equipment type cannot be null");
        this.shadow$update(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY, component -> component.withModifierAdded(BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)((Attribute)attributeType)), (net.minecraft.world.entity.ai.attributes.AttributeModifier)modifier, SpongeItemStack.asEquipmentSlotGroup(equipmentType)));
    }

    @Override
    public int contentVersion() {
        return 3;
    }

    @Override
    public DataContainer toContainer() {
        return SpongeItemStack.getDataContainer((ItemStack)this);
    }

    public ItemStackSnapshot itemStack$createSnapshot() {
        return new SpongeItemStackSnapshot((org.spongepowered.api.item.inventory.ItemStack)((Object)this));
    }

    public boolean itemStack$equalTo(org.spongepowered.api.item.inventory.ItemStack that) {
        return ItemStack.matches((ItemStack)((ItemStack)this), (ItemStack)((ItemStack)that));
    }

    @Intrinsic
    public boolean itemStack$isEmpty() {
        return this.shadow$isEmpty();
    }

    public Component asComponent() {
        return SpongeAdventure.asAdventure(this.shadow$getDisplayName());
    }

    public @NonNull HoverEvent<// Could not load outer class - annotation placement on inner may be incorrect
    HoverEvent.ShowItem> asHoverEvent(@NonNull UnaryOperator<// Could not load outer class - annotation placement on inner may be incorrect
    HoverEvent.ShowItem> op) {
        HoverEvent.ShowItem event = HoverEvent.ShowItem.showItem((Keyed)SpongeAdventure.asAdventure(SpongeCommon.vanillaRegistry(Registries.ITEM).getKey((Object)this.shadow$getItem())), (int)this.shadow$getCount(), Map.of());
        return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)Objects.requireNonNull(op, "op").apply(event)));
    }
}

