/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.entity.carrier.NameableCarrierBlockEntity;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.mixin.api.minecraft.world.level.block.entity.BlockEntityMixin_API;
import org.spongepowered.common.util.Constants;

@Mixin(value={BaseContainerBlockEntity.class})
public abstract class BaseContainerBlockEntityMixin_API
extends BlockEntityMixin_API
implements NameableCarrierBlockEntity {
    @Shadow
    private @Nullable LockCode lockKey;
    @Shadow
    private @Nullable Component name;

    @Override
    public DataContainer toContainer() {
        DataContainer container = super.toContainer();
        if (this.lockKey != null) {
            container.set(Constants.TileEntity.LOCK_CODE, this.lockKey.key());
        }
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < ((Container)this).getContainerSize(); ++i) {
            net.minecraft.world.item.ItemStack stack = ((Container)this).getItem(i);
            if (stack.isEmpty()) continue;
            DataContainer stackView = DataContainer.createNew().set(Queries.CONTENT_VERSION, 1).set(Constants.TileEntity.SLOT, i).set(Constants.TileEntity.SLOT_ITEM, ((ItemStack)stack).toContainer());
            items.add(stackView);
        }
        if (this.name != null) {
            container.set(Constants.TileEntity.LOCKABLE_CONTAINER_CUSTOM_NAME, this.name);
        }
        container.set(Constants.TileEntity.ITEM_CONTENTS, items);
        return container;
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.displayName().asImmutable());
        this.lockToken().map(Value::asImmutable).ifPresent(values::add);
        return values;
    }
}

