/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block.entity;

import java.util.Set;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.entity.CommandBlock;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.mixin.api.minecraft.world.level.block.entity.BlockEntityMixin_API;
import org.spongepowered.common.util.Constants;

@Mixin(value={CommandBlockEntity.class})
public abstract class CommandBlockEntityMixin_API
extends BlockEntityMixin_API
implements CommandBlock {
    @Shadow
    public abstract BaseCommandBlock shadow$getCommandBlock();

    @Override
    public void execute() {
        this.shadow$getCommandBlock().performCommand(this.level);
    }

    @Override
    public String name() {
        return this.shadow$getCommandBlock().getName().getString();
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = super.toContainer();
        container.set(Constants.TileEntity.CommandBlock.STORED_COMMAND, this.shadow$getCommandBlock().getCommand());
        container.set(Constants.TileEntity.CommandBlock.SUCCESS_COUNT, this.shadow$getCommandBlock().getSuccessCount());
        container.set(Constants.TileEntity.CUSTOM_NAME, this.shadow$getCommandBlock().getName());
        container.set(Constants.TileEntity.CommandBlock.DOES_TRACK_OUTPUT, this.shadow$getCommandBlock().shouldInformAdmins());
        if (this.shadow$getCommandBlock().shouldInformAdmins()) {
            container.set(Constants.TileEntity.CommandBlock.TRACKED_OUTPUT, LegacyComponentSerializer.legacySection().serialize(SpongeAdventure.asAdventure(this.shadow$getCommandBlock().getLastOutput())));
        }
        return container;
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.storedCommand().asImmutable());
        values.add(this.successCount().asImmutable());
        values.add(this.doesTrackOutput().asImmutable());
        this.lastOutput().map(Value::asImmutable).ifPresent(values::add);
        return values;
    }

    @Override
    public String identifier() {
        return this.shadow$getCommandBlock().getName().getString();
    }

    public void sendMessage(@NonNull Identity identity, @NonNull Component message, @NonNull MessageType type) {
        this.shadow$getCommandBlock().sendSystemMessage(SpongeAdventure.asVanilla(message));
    }
}

