/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.generation.GenerationChunk;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.holder.SpongeServerLocationBaseDataHolder;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.world.schematic.PaletteWrapper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={ProtoChunk.class})
public abstract class ProtoChunkMixin_API
extends ChunkAccess
implements GenerationChunk,
SpongeServerLocationBaseDataHolder {
    @Shadow
    private @Nullable BelowZeroRetrogen belowZeroRetrogen;
    private @Nullable Vector3i api$blockMin;
    private @Nullable Vector3i api$blockMax;

    @Shadow
    public abstract Map<BlockPos, net.minecraft.world.level.block.entity.BlockEntity> shadow$getBlockEntities();

    @Shadow
    public abstract void shadow$setBlockEntity(net.minecraft.world.level.block.entity.BlockEntity var1);

    @Shadow
    public abstract void shadow$removeBlockEntity(BlockPos var1);

    @Shadow
    public abstract Holder<net.minecraft.world.level.biome.Biome> shadow$getNoiseBiome(int var1, int var2, int var3);

    public ProtoChunkMixin_API(ChunkPos $$0, UpgradeData $$1, LevelHeightAccessor $$2, net.minecraft.core.Registry<net.minecraft.world.level.biome.Biome> $$3, long $$4, LevelChunkSection[] $$5, BlendingData $$6) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6);
    }

    @Override
    public Palette<BlockState, BlockType> blockPalette() {
        return PaletteWrapper.of(PaletteTypes.BLOCK_STATE_PALETTE.get(), Block.BLOCK_STATE_REGISTRY, (Registry)SpongeCommon.vanillaRegistry(Registries.BLOCK));
    }

    @Override
    public VolumeStream<GenerationChunk, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream biomes on ProtoChunk");
    }

    @Override
    public VolumeStream<GenerationChunk, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream block states on ProtoChunk");
    }

    @Override
    public VolumeStream<GenerationChunk, BlockEntity> blockEntityStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream block entities on ProtoChunk");
    }

    @Override
    public Vector3i min() {
        if (this.api$blockMin == null) {
            this.api$blockMin = SpongeChunkLayout.INSTANCE.forceToWorld(this.chunkPosition());
        }
        return this.api$blockMin;
    }

    @Override
    public Vector3i max() {
        if (this.api$blockMax == null) {
            this.api$blockMax = this.min().add(SpongeChunkLayout.INSTANCE.chunkSize()).sub(1, 1, 1);
        }
        return this.api$blockMax;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return false;
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return false;
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        if (!(this.getStatus().isOrAfter(ChunkStatus.BIOMES) || this.belowZeroRetrogen != null && this.belowZeroRetrogen.targetStatus().isOrAfter(ChunkStatus.BIOMES))) {
            throw new IllegalStateException("Asking for biomes before we have biomes");
        }
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> this.getSection(this.getSectionIndex(y)), () -> {});
    }

    @Override
    public Collection<? extends BlockEntity> blockEntities() {
        return Collections.unmodifiableCollection(this.shadow$getBlockEntities().values());
    }

    @Override
    public Ticks inhabitedTime() {
        return new SpongeTicks(this.getInhabitedTime());
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        this.shadow$setBlockEntity((net.minecraft.world.level.block.entity.BlockEntity)blockEntity);
    }

    @Override
    public void setInhabitedTime(Ticks newInhabitedTime) {
        Objects.requireNonNull(newInhabitedTime);
        if (newInhabitedTime.isInfinite()) {
            throw new IllegalArgumentException("Inhabited time cannot be infinite!");
        }
        this.setInhabitedTime(newInhabitedTime.ticks());
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.shadow$removeBlockEntity(new BlockPos(x, y, z));
    }

    @Override
    public Biome biome(int x, int y, int z) {
        if (!this.contains(x, y, z)) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        return (Biome)this.shadow$getNoiseBiome(x, y, z).value();
    }

    @Override
    public ServerLocation impl$dataholder(int x, int y, int z) {
        throw new MissingImplementationException("ProtoChunk", "impl$dataholder");
    }
}

